/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.parameterlabel;

import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.antlr.ParameterLabelLexer;
import org.eclipse.papyrus.parsers.antlr.ParameterLabelParser;
import org.eclipse.papyrus.parsers.texteditor.CompletionFilterSourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.LabelCompletionProcessor;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.DefaultValueCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.DirectionCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.MultiplicityCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.NameCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ParameterModifierProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ParameterModifiersProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.TypeCompletionProposalComputer;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.VisibilityCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.IContext;
import org.eclipse.papyrus.parsers.util.SimpleStringErrorReporter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterLabelCompletionProcessor
extends LabelCompletionProcessor
implements IContext {
    private final CompletionFilterSourceViewerConfiguration.ICompletionFilter completionFilter;
    private Parameter parameter;
    private Map<String, Boolean> modifiersUsed;

    public ParameterLabelCompletionProcessor(Parameter parameter) {
        this.parameter = parameter;
        this.completionFilter = new CompletionFilterSourceViewerConfiguration.NullCompletionFilter();
    }

    public ParameterLabelCompletionProcessor(Parameter parameter, CompletionFilterSourceViewerConfiguration.ICompletionFilter iCompletionFilter) {
        this.parameter = parameter;
        this.completionFilter = iCompletionFilter;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String prefix = "";
        ParameterLabelLexer lexer = null;
        ParameterLabelParser parser = null;
        Collection<ICompletionProposal> result = null;
        int selectionRange = 0;
        try {
            String text = viewer.getDocument().get(0, documentOffset);
            lexer = new ParameterLabelLexer((CharStream)new ANTLRStringStream(text));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new ParameterLabelParser((TokenStream)tokens, this.parameter, new SimpleStringErrorReporter());
            parser.setValidation(true);
            selectionRange = viewer.getSelectedRange().y;
            parser.label();
            this.modifiersUsed = parser.getModifiersUsed();
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            this.modifiersUsed = parser.getModifiersUsed();
            prefix = this.getPrefix(viewer, documentOffset);
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        catch (RecognitionException e) {
            this.modifiersUsed = parser.getModifiersUsed();
            prefix = this.getPrefix(viewer, documentOffset);
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        return result.toArray(new ICompletionProposal[0]);
    }

    @Override
    public Collection<ICompletionProposal> computeCompletions(ITextViewer viewer, int context, int documentOffset, int selectionRange) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        ParameterModifierProposal modifierProposalComputer = new ParameterModifierProposal();
        modifierProposalComputer.setModifiersUsed(this.modifiersUsed);
        String prefix = this.getPrefix(viewer, documentOffset);
        switch (context) {
            case 0: {
                v.addAll(new VisibilityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new DirectionCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 1: {
                v.addAll(new DirectionCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 2: {
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 3: {
                v.addAll(this.createCompletionProposalsWithDifferentName(new String[]{": ", ": <Undefined>"}, new String[]{"Parameter type", "Undefined Parameter type"}, new String[]{": <Type Name>", ": <Undefined>"}, "", documentOffset));
                break;
            }
            case 4: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                TypeCompletionProposalComputer computer = new TypeCompletionProposalComputer(this.completionFilter, 4);
                computer.setElement((Element)this.parameter);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 5: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                TypeCompletionProposalComputer computer = new TypeCompletionProposalComputer(this.completionFilter, 5);
                computer.setElement((Element)this.parameter);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 6: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                TypeCompletionProposalComputer computer = new TypeCompletionProposalComputer(this.completionFilter, 4);
                computer.setElement((Element)this.parameter);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new MultiplicityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new DefaultValueCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new ParameterModifiersProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 10: {
                prefix = this.getPrefixForMultiplicity(viewer, documentOffset);
                v.addAll(new MultiplicityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 11: {
                v.addAll(new DefaultValueCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new ParameterModifiersProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 7: {
                v.addAll(new ParameterModifiersProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 8: {
                v.addAll(modifierProposalComputer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 9: {
                v.addAll(modifierProposalComputer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
        }
        return v;
    }
}

