/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.parameterlabel;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.papyrus.parsers.texteditor.WhitespaceDetector;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ParameterModifierProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.VisibilityCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.IParameterLabelColorConstants;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.ParameterLabelColorProvider;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.ParameterWordDetector;
import org.eclipse.swt.graphics.Color;

public class ParameterLabelScanner
extends RuleBasedScanner
implements IParameterLabelColorConstants {
    private Color defaultColor = ParameterLabelColorProvider.getDefault().getColor("default");
    private Color keywordColor = ParameterLabelColorProvider.getDefault().getColor("keyword");
    private Color symbolColor = ParameterLabelColorProvider.getDefault().getColor("symbol");

    public ParameterLabelScanner() {
        Token other = new Token((Object)new TextAttribute(this.defaultColor));
        Token keyword = new Token((Object)new TextAttribute(this.keywordColor, null, 1));
        Token symbol = new Token((Object)new TextAttribute(this.symbolColor, null, 1));
        IRule[] rules = new IRule[2];
        WordRule wordRule = new WordRule((IWordDetector)new ParameterWordDetector(), (IToken)other);
        int i = 0;
        while (i < VisibilityCompletionProposal.visibilityStrings.length) {
            ++i;
        }
        i = 0;
        while (i < ParameterModifierProposal.modifiersStrings.length) {
            wordRule.addWord(ParameterModifierProposal.modifiersStrings[i].trim(), (IToken)keyword);
            ++i;
        }
        wordRule.addWord("+", (IToken)symbol);
        wordRule.addWord("-", (IToken)symbol);
        wordRule.addWord("#", (IToken)symbol);
        wordRule.addWord("~", (IToken)symbol);
        wordRule.addWord("/", (IToken)symbol);
        wordRule.addWord("+/", (IToken)symbol);
        wordRule.addWord("-/", (IToken)symbol);
        wordRule.addWord("#/", (IToken)symbol);
        wordRule.addWord(":", (IToken)symbol);
        wordRule.addWord("in", (IToken)symbol);
        wordRule.addWord("out", (IToken)symbol);
        wordRule.addWord("inout", (IToken)symbol);
        wordRule.addWord("return", (IToken)symbol);
        rules[0] = wordRule;
        rules[1] = new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector());
        this.setRules(rules);
    }

    public static String getWordWithoutQuotes(String word) {
        String tmp = "";
        tmp = word.replaceAll("'", "");
        return tmp;
    }
}

