/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.parameterlabel;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.papyrus.parsers.texteditor.CompletionFilterSourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.ParameterLabelColorProvider;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.ParameterLabelCompletionProcessor;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.ParameterLabelScanner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.Parameter;

public class ParameterLabelSourceViewerConfiguration
extends CompletionFilterSourceViewerConfiguration {
    private Parameter parameter;

    public ParameterLabelSourceViewerConfiguration(Parameter parameter) {
        super(null);
        this.setParameter(parameter);
    }

    public ParameterLabelSourceViewerConfiguration() {
        this(null, null);
    }

    public ParameterLabelSourceViewerConfiguration(Parameter parameter, CompletionFilterSourceViewerConfiguration.ICompletionFilter filter) {
        super(filter);
        this.setParameter(parameter);
    }

    public ParameterLabelSourceViewerConfiguration(CompletionFilterSourceViewerConfiguration.ICompletionFilter filter) {
        this(null, filter);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        Color colorString = ParameterLabelColorProvider.getDefault().getColor("string");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorString)));
        reconciler.setDamager((IPresentationDamager)dr, "_rt_action_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "_rt_action_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)new ParameterLabelScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        ParameterLabelCompletionProcessor processor = new ParameterLabelCompletionProcessor(this.parameter, this.getFilter());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        return assistant;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

