/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.propertylabel;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.parsers.modelgenerator.PropertyGenerator;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyLabelSourceViewerConfiguration;
import org.eclipse.papyrus.umlutils.PropertyUtil;
import org.eclipse.uml2.uml.Property;

public class PropertyConfigurationForUML
extends DefaultDirectEditorConfiguration {
    private final PropertyLabelSourceViewerConfiguration configuration = new PropertyLabelSourceViewerConfiguration();

    public SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.configuration;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Property) {
            return PropertyUtil.getLabel((Property)((Property)editedObject));
        }
        return "not a Property";
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof Property) {
            this.configuration.setProperty((Property)objectToEdit);
        }
        return super.preEditAction(objectToEdit);
    }

    public Object postEditAction(Object editedObject, String text) {
        if (editedObject instanceof Property) {
            PropertyGenerator generator = new PropertyGenerator((Property)editedObject);
            generator.parseAndModifyProperty(text);
        }
        return null;
    }

    public IInputValidator getInputValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (PropertyConfigurationForUML.this.getObjectToEdit() instanceof Property) {
                    PropertyGenerator generator = new PropertyGenerator((Property)PropertyConfigurationForUML.this.getObjectToEdit());
                    return generator.parseAndValidateProperty(newText);
                }
                return null;
            }
        };
    }

    public IDirectEditorConfiguration.Selection getTextSelection(String value, Object editedObject) {
        if (editedObject instanceof Property) {
            Property property = (Property)editedObject;
            String name = PropertyUtil.getName((Property)property);
            int start = value.indexOf(name);
            int length = name.length();
            return new IDirectEditorConfiguration.Selection(start, length);
        }
        return super.getTextSelection(value, editedObject);
    }
}

