/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.propertylabel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.parsers.PapyrusParsersPlugin;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.IPropertyLabelColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PropertyLabelColorProvider
implements IPropertyLabelColorConstants {
    private static PropertyLabelColorProvider instance;
    protected Map<String, Color> fColorTable = new HashMap<String, Color>(10);

    private PropertyLabelColorProvider() {
    }

    public static PropertyLabelColorProvider getDefault() {
        if (instance == null) {
            instance = new PropertyLabelColorProvider();
        }
        return instance;
    }

    public static void initializeDefaults(IPreferenceStore aStore) {
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.default", (RGB)IPropertyLabelColorConstants.RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.keyword", (RGB)IPropertyLabelColorConstants.RGB_KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.string", (RGB)IPropertyLabelColorConstants.RGB_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.symbol", (RGB)IPropertyLabelColorConstants.RGB_SYMBOL);
    }

    public Color getColor(String aName) {
        Color color = this.fColorTable.get(aName);
        if (color == null) {
            IPreferenceStore store = PapyrusParsersPlugin.getDefault().getPreferenceStore();
            PreferenceConverter.setValue((IPreferenceStore)store, (String)"org.eclipse.papyrus.classdiagram.parsers.color.symbol", (RGB)IPropertyLabelColorConstants.RGB_SYMBOL);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)("org.eclipse.papyrus.classdiagram.parsers.color." + aName));
            if (rgb != null) {
                color = new Color((Device)Display.getCurrent(), rgb);
            } else {
                color = Display.getCurrent().getSystemColor(24);
                PapyrusParsersPlugin.logError("Undefined color '" + aName + "'");
            }
            this.fColorTable.put(aName, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> colors = this.fColorTable.values().iterator();
        while (colors.hasNext()) {
            colors.next().dispose();
        }
    }
}

