/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.propertylabel;

import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.antlr.PropertyLabelLexer;
import org.eclipse.papyrus.parsers.antlr.PropertyLabelParser;
import org.eclipse.papyrus.parsers.texteditor.CompletionFilterSourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.LabelCompletionProcessor;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.DefaultValueCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.DerivedPropertyCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.MultiplicityCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.NameCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.PropertyModifierProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.PropertyModifiersProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.PropertyRedefineProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.PropertySubsetsProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.TypeCompletionProposalComputer;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.VisibilityCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.IContext;
import org.eclipse.papyrus.parsers.util.SimpleStringErrorReporter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLabelCompletionProcessor
extends LabelCompletionProcessor
implements IContext {
    private final CompletionFilterSourceViewerConfiguration.ICompletionFilter completionFilter;
    private Property property;
    private Map<String, Boolean> modifiersUsed;

    public PropertyLabelCompletionProcessor(Property property) {
        this.property = property;
        this.completionFilter = new CompletionFilterSourceViewerConfiguration.NullCompletionFilter();
    }

    public PropertyLabelCompletionProcessor(Property property, CompletionFilterSourceViewerConfiguration.ICompletionFilter iCompletionFilter) {
        this.property = property;
        this.completionFilter = iCompletionFilter;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String prefix = "";
        PropertyLabelLexer lexer = null;
        PropertyLabelParser parser = null;
        Collection<ICompletionProposal> result = null;
        int selectionRange = 0;
        try {
            String text = viewer.getDocument().get(0, documentOffset);
            lexer = new PropertyLabelLexer((CharStream)new ANTLRStringStream(text));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new PropertyLabelParser((TokenStream)tokens, this.property, new SimpleStringErrorReporter());
            parser.setValidation(true);
            selectionRange = viewer.getSelectedRange().y;
            parser.label();
            this.modifiersUsed = parser.getModifiersUsed();
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            this.modifiersUsed = parser.getModifiersUsed();
            prefix = this.getPrefix(viewer, documentOffset);
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        catch (RecognitionException e) {
            this.modifiersUsed = parser.getModifiersUsed();
            prefix = this.getPrefix(viewer, documentOffset);
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        return result.toArray(new ICompletionProposal[0]);
    }

    @Override
    public Collection<ICompletionProposal> computeCompletions(ITextViewer viewer, int context, int documentOffset, int selectionRange) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        PropertyModifierProposal modifierProposalComputer = new PropertyModifierProposal();
        modifierProposalComputer.setModifiersUsed(this.modifiersUsed);
        String prefix = this.getPrefix(viewer, documentOffset);
        switch (context) {
            case 0: {
                v.addAll(new VisibilityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new DerivedPropertyCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 1: {
                v.addAll(new DerivedPropertyCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 2: {
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 3: {
                v.addAll(this.createCompletionProposalsWithDifferentName(new String[]{": ", ": <Undefined>"}, new String[]{"Property type", "Undefined property type"}, new String[]{": <Type Name>", ": <Undefined>"}, "", documentOffset));
                break;
            }
            case 4: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                TypeCompletionProposalComputer computer = new TypeCompletionProposalComputer(this.completionFilter, 4);
                computer.setElement((Element)this.property);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 5: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                TypeCompletionProposalComputer computer = new TypeCompletionProposalComputer(this.completionFilter, 5);
                computer.setElement((Element)this.property);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 6: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                TypeCompletionProposalComputer computer = new TypeCompletionProposalComputer(this.completionFilter, 4);
                computer.setElement((Element)this.property);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new MultiplicityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new DefaultValueCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new PropertyModifiersProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 10: {
                prefix = this.getPrefixForMultiplicity(viewer, documentOffset);
                v.addAll(new MultiplicityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 13: {
                v.addAll(new DefaultValueCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new PropertyModifiersProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 7: {
                v.addAll(new PropertyModifiersProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 8: {
                v.addAll(modifierProposalComputer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 9: {
                v.addAll(modifierProposalComputer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 11: {
                v.addAll(new PropertySubsetsProposal(this.property).generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 12: {
                v.addAll(new PropertyRedefineProposal(this.property).generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
        }
        return v;
    }
}

