/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.propertylabel;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.papyrus.parsers.texteditor.WhitespaceDetector;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.DerivedPropertyCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.PropertyModifierProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.VisibilityCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.IPropertyLabelColorConstants;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyLabelColorProvider;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyWordDetector;
import org.eclipse.swt.graphics.Color;

public class PropertyLabelScanner
extends RuleBasedScanner
implements IPropertyLabelColorConstants {
    private Color defaultColor = PropertyLabelColorProvider.getDefault().getColor("default");
    private Color keywordColor = PropertyLabelColorProvider.getDefault().getColor("keyword");
    private Color symbolColor = PropertyLabelColorProvider.getDefault().getColor("symbol");

    public PropertyLabelScanner() {
        Token other = new Token((Object)new TextAttribute(this.defaultColor));
        Token keyword = new Token((Object)new TextAttribute(this.keywordColor, null, 1));
        Token symbol = new Token((Object)new TextAttribute(this.symbolColor, null, 1));
        IRule[] rules = new IRule[2];
        WordRule wordRule = new WordRule((IWordDetector)new PropertyWordDetector(), (IToken)other);
        int i = 0;
        while (i < VisibilityCompletionProposal.visibilityStrings.length) {
            ++i;
        }
        i = 0;
        while (i < DerivedPropertyCompletionProposal.derivedPropertyStrings.length) {
            ++i;
        }
        i = 0;
        while (i < PropertyModifierProposal.modifiersStrings.length) {
            wordRule.addWord(PropertyModifierProposal.modifiersStrings[i].trim(), (IToken)keyword);
            ++i;
        }
        wordRule.addWord("+", (IToken)symbol);
        wordRule.addWord("-", (IToken)symbol);
        wordRule.addWord("#", (IToken)symbol);
        wordRule.addWord("~", (IToken)symbol);
        wordRule.addWord("/", (IToken)symbol);
        wordRule.addWord("+/", (IToken)symbol);
        wordRule.addWord("-/", (IToken)symbol);
        wordRule.addWord("#/", (IToken)symbol);
        wordRule.addWord(":", (IToken)symbol);
        rules[0] = wordRule;
        rules[1] = new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector());
        this.setRules(rules);
    }

    public static String getWordWithoutQuotes(String word) {
        String tmp = "";
        tmp = word.replaceAll("'", "");
        return tmp;
    }
}

