/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.propertylabel;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.papyrus.parsers.texteditor.CompletionFilterSourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyLabelColorProvider;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyLabelCompletionProcessor;
import org.eclipse.papyrus.parsers.texteditor.propertylabel.PropertyLabelScanner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.Property;

public class PropertyLabelSourceViewerConfiguration
extends CompletionFilterSourceViewerConfiguration {
    private Property property;

    public PropertyLabelSourceViewerConfiguration() {
        this(null, null);
    }

    public PropertyLabelSourceViewerConfiguration(Property property) {
        super(null);
        this.setProperty(property);
    }

    public PropertyLabelSourceViewerConfiguration(Property property, CompletionFilterSourceViewerConfiguration.ICompletionFilter filter) {
        super(filter);
        this.setProperty(property);
    }

    public PropertyLabelSourceViewerConfiguration(CompletionFilterSourceViewerConfiguration.ICompletionFilter filter) {
        this(null, filter);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        Color colorString = PropertyLabelColorProvider.getDefault().getColor("string");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorString)));
        reconciler.setDamager((IPresentationDamager)dr, "_rt_action_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "_rt_action_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)new PropertyLabelScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        PropertyLabelCompletionProcessor processor = new PropertyLabelCompletionProcessor(this.property, this.getFilter());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        return assistant;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

