/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.pastemanager.service;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.pastemanager.Activator;
import org.eclipse.papyrus.pastemanager.command.CommentDropCreation;
import org.eclipse.papyrus.pastemanager.command.PapyrusDuplicateWrapperCommand;
import org.eclipse.papyrus.pastemanager.request.PasteRequest;
import org.eclipse.papyrus.pastemanager.service.IPasteCommandProvider;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPasteCommandProvider
implements IPasteCommandProvider {
    @Override
    public ICommand getPasteViewCommand(GraphicalEditPart targetEditPart, Clipboard systemClipboard, Collection<Object> papyrusClipboard) {
        PasteRequest pasteRequest;
        Command pasteCommand;
        if (!System.getProperty("os.name").equals("Linux")) {
            String bufferSystem = null;
            DataFlavor[] dataFlavors = Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors();
            int i = 0;
            while (i < dataFlavors.length) {
                try {
                    if (dataFlavors[i].isFlavorTextType() && dataFlavors[i].isMimeTypeEqual(DataFlavor.stringFlavor)) {
                        bufferSystem = Toolkit.getDefaultToolkit().getSystemClipboard().getData(dataFlavors[i]).toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (bufferSystem != null) {
                return this.pasteFromSystem(targetEditPart, bufferSystem);
            }
        }
        if ((pasteCommand = targetEditPart.getCommand((Request)(pasteRequest = new PasteRequest(targetEditPart.getEditingDomain().getClipboard())))) != null) {
            return new CommandProxy(pasteCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public ICommand pasteFromSystem(GraphicalEditPart targetEditPart, String comment) {
        return new CommentDropCreation("paste", comment, targetEditPart.getNotationView().getElement(), targetEditPart);
    }

    @Override
    public ICommand getPasteWithModelCommand(GraphicalEditPart targetEditPart, Clipboard systemClipboard, Collection<Object> papyrusCliboard) {
        String bufferSystem = null;
        if (!System.getProperty("os.name").equals("Linux")) {
            DataFlavor[] dataFlavors = Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors();
            int i = 0;
            while (i < dataFlavors.length) {
                try {
                    if (dataFlavors[i].isFlavorTextType() && dataFlavors[i].isMimeTypeEqual(DataFlavor.stringFlavor)) {
                        bufferSystem = Toolkit.getDefaultToolkit().getSystemClipboard().getData(dataFlavors[i]).toString();
                    }
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
                ++i;
            }
            if (bufferSystem != null) {
                return this.pasteFromSystem(targetEditPart, bufferSystem);
            }
        }
        ArrayList<Object> objectToPaste = new ArrayList<Object>();
        if (papyrusCliboard != null && papyrusCliboard.size() >= 1) {
            objectToPaste.addAll(papyrusCliboard);
            for (Object object : papyrusCliboard) {
                if (!(object instanceof View)) continue;
                objectToPaste.add(((View)object).getElement());
                ArrayList stereotypedSelection = new ArrayList();
                EObject semantic = ((View)object).getElement();
                if (semantic instanceof Element) {
                    stereotypedSelection.addAll(((Element)semantic).getStereotypeApplications());
                }
                TreeIterator iter = semantic.eAllContents();
                while (iter.hasNext()) {
                    EObject subeObject = (EObject)iter.next();
                    if (!(subeObject instanceof Element)) continue;
                    stereotypedSelection.addAll(((Element)subeObject).getStereotypeApplications());
                }
                objectToPaste.addAll(stereotypedSelection);
            }
            DuplicateElementsRequest duplicateElementRequest = new DuplicateElementsRequest(targetEditPart.getEditingDomain(), objectToPaste);
            RootEditPart topEditPart = targetEditPart.getRoot();
            if (topEditPart.getChildren().get(0) instanceof DiagramEditPart) {
                Command gefCommand = ((DiagramEditPart)topEditPart.getChildren().get(0)).getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)duplicateElementRequest));
                PapyrusDuplicateWrapperCommand command = new PapyrusDuplicateWrapperCommand(targetEditPart.getEditingDomain(), "", objectToPaste, (ICommandProxy)gefCommand, (View)targetEditPart.getModel());
                return command;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }
}

