/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.pastemanager.service;

import java.awt.datatransfer.Clipboard;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.papyrus.pastemanager.Activator;
import org.eclipse.papyrus.pastemanager.service.IPasteCommandProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteCommandService {
    protected static final String PASTECOMMANDPROVIDER_EXTENSION_ID = "org.eclipse.papyrus.pastemanager.pasteCommandProvider";
    protected static final String REALIZATION = "realization";
    protected static final String PRIORITY = "priority";
    protected static PasteCommandService instance = null;
    protected Map<String, IPasteCommandProvider> pasteCommandProviderMap;

    public static PasteCommandService getInstance() {
        if (instance == null) {
            instance = new PasteCommandService();
        }
        return instance;
    }

    protected static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension" + e);
        }
    }

    private PasteCommandService() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PASTECOMMANDPROVIDER_EXTENSION_ID);
        this.pasteCommandProviderMap = new HashMap<String, IPasteCommandProvider>();
        int i = 0;
        while (i < configElements.length) {
            this.getPasteCommandProvider(configElements[i]);
            ++i;
        }
    }

    protected void getPasteCommandProvider(IConfigurationElement element) {
        IPasteCommandProvider pasteCommandProvider = null;
        try {
            pasteCommandProvider = (IPasteCommandProvider)PasteCommandService.createExtension(element, element.getAttribute(REALIZATION));
            String priority = element.getAttribute(PRIORITY);
            this.pasteCommandProviderMap.put(priority, pasteCommandProvider);
        }
        catch (Exception e) {
            Activator.log.error("- " + pasteCommandProvider + " can not be loaded: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected IPasteCommandProvider lookForProvider() {
        String[] priority = new String[]{"Highest", "High", "Medium", "Low", "Lowest"};
        IPasteCommandProvider selectedProvider = null;
        int i = 0;
        while (selectedProvider == null && i < priority.length) {
            selectedProvider = this.pasteCommandProviderMap.get(priority[i]);
            ++i;
        }
        return selectedProvider;
    }

    public ICommand getPasteViewCommand(GraphicalEditPart targetEditPart, Clipboard systemClipboard, Collection<Object> papyrusCliboard) {
        IPasteCommandProvider selectedProvider = this.lookForProvider();
        if (selectedProvider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return selectedProvider.getPasteViewCommand(targetEditPart, systemClipboard, papyrusCliboard);
    }

    public ICommand getPasteWithModelCommand(GraphicalEditPart targetEditPart, Clipboard systemClipboard, Collection<Object> papyrusCliboard) {
        IPasteCommandProvider selectedProvider = this.lookForProvider();
        if (selectedProvider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return selectedProvider.getPasteWithModelCommand(targetEditPart, systemClipboard, papyrusCliboard);
    }
}

