/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.preferences.jface.preference;

import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ColorFieldEditor
extends FieldEditor {
    private Image buttonImage;
    private Image backgroundImage;
    private ColorPalettePopup colorSelector;
    private Button colorButton;

    public ColorFieldEditor(String name, Image image, Composite parent) {
        super(name, "", parent);
        this.backgroundImage = image;
    }

    public void load() {
        super.load();
        this.buttonImage = new ColorOverlayImageDescriptor(this.backgroundImage.getImageData(), PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName())).createImage();
        this.colorButton.setImage(this.buttonImage);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.colorButton = new Button(parent, 8);
        this.colorButton.setLayoutData((Object)new GridData());
        this.colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorFieldEditor.this.changeColors(ColorFieldEditor.this.colorButton);
            }
        });
    }

    protected void doLoad() {
        this.doLoadColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.doLoadColor(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName()));
    }

    private void doLoadColor(RGB rgb) {
        this.updateButtonImage(rgb);
        if (this.colorSelector != null) {
            this.colorSelector.setPreviousColor(FigureUtilities.RGBToInteger((RGB)rgb).intValue());
        }
    }

    protected void doStore() {
        if (this.colorSelector != null) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (RGB)this.colorSelector.getSelectedColor());
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    private void changeColors(Button button) {
        this.colorSelector = new ColorPalettePopup(this.colorButton.getParent().getShell(), 25);
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        this.colorSelector.open(location);
        if (this.colorSelector.getSelectedColor() == null && !this.colorSelector.useDefaultColor()) {
            return;
        }
        this.updateButtonImage(this.colorSelector.getSelectedColor());
    }

    private void updateButtonImage(RGB rgb) {
        if (!this.colorButton.isDisposed() && this.colorButton.getImage() != null && !this.colorButton.getImage().isDisposed()) {
            this.colorButton.getImage().dispose();
            Image overlyedImage = new ColorOverlayImageDescriptor(this.backgroundImage.getImageData(), rgb).createImage();
            this.colorButton.setImage(overlyedImage);
        }
    }

    protected static class ColorOverlayImageDescriptor
    extends CompositeImageDescriptor {
        private static final Point ICON_SIZE = new Point(16, 16);
        private ImageData basicImgData;
        private RGB rgb;

        public ColorOverlayImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(width, height / 5, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 0, height - height / 5);
            }
            this.drawImage(this.basicImgData, 0, 0);
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }
}

