/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.preferences.pages;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.papyrus.preferences.Activator;
import org.eclipse.papyrus.preferences.pages.internal.VisiblePageSingleton;
import org.eclipse.papyrus.preferences.ui.AbstractGroup;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class AbstractPapyrusPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IProject project;
    private Set<AbstractGroup> groupSet;
    private String key;

    public IAdaptable getElement() {
        return this.project;
    }

    protected void setPreferenceKey(String aKey) {
        this.key = aKey;
    }

    protected String getPreferenceKey() {
        return this.key;
    }

    public IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        ScopedPreferenceStore store = this.project != null ? new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), this.getBundleId()) : new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundleId());
        return store;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout();
        container.setLayout((Layout)containerLayout);
        this.createPageContents(container);
        this.initGroup();
        return container;
    }

    protected abstract void createPageContents(Composite var1);

    protected void addAbstractGroup(AbstractGroup fe) {
        if (this.groupSet == null) {
            this.groupSet = new HashSet<AbstractGroup>();
        }
        this.groupSet.add(fe);
    }

    public boolean performOk() {
        VisiblePageSingleton.getInstance().store();
        return super.performOk();
    }

    protected void storePreferences() {
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.storePreferences();
            }
        }
    }

    public void storeAllPreferences() {
        this.storePreferences();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    private void loadDefaultPreferences() {
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.loadDefault();
            }
        }
    }

    private void initGroup() {
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.setPreferenceStore(this.getPreferenceStore());
                gs.load();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.groupSet != null) {
            for (AbstractGroup gs : this.groupSet) {
                gs.dispose();
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            VisiblePageSingleton.getInstance().setVisiblePage((IPreferencePage)this);
            this.initGroup();
        }
        super.setVisible(visible);
    }

    protected abstract String getBundleId();
}

