/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.preferences.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CLabelBooleanFieldEditor
extends BooleanFieldEditor {
    private CLabel cLabel = null;
    private Button checkBox = null;
    private int style = 16384;
    private Image image = null;

    public CLabelBooleanFieldEditor(String preferenceKey, String labelText, int style, Image im, Composite parent) {
        this.image = im;
        this.style = 16384 == style ? 16384 : 131072;
        this.init(preferenceKey, labelText);
        this.createControl(parent);
    }

    public CLabelBooleanFieldEditor(String preferenceKey, String labelText, Image im, Composite parent) {
        this(preferenceKey, labelText, 131072, im, parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData gd = new GridData();
        switch (this.style) {
            case 16384: {
                this.getCLabelControl(parent);
                this.checkBox = this.getChangeControl(parent);
                this.checkBox.setLayoutData((Object)gd);
            }
            case 131072: {
                this.checkBox = this.getChangeControl(parent);
                this.checkBox.setLayoutData((Object)gd);
                this.getCLabelControl(parent);
            }
        }
    }

    protected CLabel getCLabelControl() {
        return this.cLabel;
    }

    public CLabel getCLabelControl(Composite parent) {
        if (this.cLabel == null) {
            String text;
            this.cLabel = new CLabel(parent, 16384);
            this.cLabel.setFont(parent.getFont());
            if (this.image != null) {
                this.cLabel.setImage(this.image);
            }
            if ((text = this.getLabelText()) != null) {
                this.cLabel.setText(text);
            }
            this.cLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CLabelBooleanFieldEditor.this.cLabel = null;
                }
            });
        } else {
            this.checkParent((Control)this.cLabel, parent);
        }
        return this.cLabel;
    }

    public void setCLabelText(String text) {
        super.setLabelText(text);
        Assert.isNotNull((Object)text);
        this.cLabel = this.getCLabelControl();
        if (this.cLabel == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    public Control getDescriptionControl(Composite parent) {
        if (this.style == 1) {
            return this.getLabelControl(parent);
        }
        return this.getChangeControl(parent);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getCLabelControl(parent).setEnabled(enabled);
        this.getChangeControl(parent).setEnabled(enabled);
    }
}

