/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.preferences.utils;

public class PreferenceConstantHelper {
    public static String PAPYRUS_EDITOR_PREFERENCE_PREFIX = "PAPYRUS_EDITOR";
    public static String DIAGRAM_PREFERENCE_PREFIX = "DIAGRAM_";
    public static String DIAGRAM_ELEMENT = "ELEMENT_";
    private static final String COLOR = "color.";
    private static final String GRADIENT = "gradient";
    private static final String POLICY = ".policy";
    private static final String JUMPLINK = "jumplink.";
    private static final String ROUTING = "routing";
    private static final String ROUTING_POLICY = "routing.policy";
    private static final String COLOR_FILL_CONSTANT = "color.fill";
    private static final String FONT_CONSTANT = "font";
    private static final String COLOR_FONT_CONSTANT = "color.font";
    private static final String COLOR_LINE_CONSTANT = "color.line";
    private static final String COLOR_GRADIENT_CONSTANT = "color.gradient";
    private static final String GRADIENT_POLICY_CONSTANT = "gradient.policy";
    private static final String JUMPLINK_STATUS_CONSTANT = "jumplink.status";
    private static final String JUMPLINK_REVERSE_CONSTANT = "jumplink.reverse";
    private static final String JUMPLINK_TYPE_CONSTANT = "jumplink.type";
    private static final String ROUTING_POLICY_DISTANCE_CONSTANT = "routing.policy.distance";
    private static final String ROUTING_POLICY_OBSTRUCTION_CONSTANT = "routing.policy.obstruction";
    private static final String ROUTING_STYLE_CONSTANT = "routing.style";
    private static final String SMOOTHNESS_CONSTANT = "smoothness";
    private static final String SHADOW_CONSTANT = "shadow";
    private static final String ELEMENTICON_CONSTANT = "elementicon";
    private static final String QUALIFIEDNAME_CONSTANT = "qualifiedname";
    private static final String HEIGHT_CONSTANT = "height";
    private static final String WIDTH_CONSTANT = "width";
    private static final String COMPARTMENT_VISIBILITY_CONSTANT = "compartment.visibility";
    private static final String COMPARTMENT_NAME_VISIBILITY_CONSTANT = "compartment_name.visibility";
    private static final String LABEL_VISIBILITY_CONSTANT = "label.visibility";
    private static final String LOCATION_X_CONSTANT = "location_x";
    private static final String LOCATION_Y_CONSTANT = "location_y";
    public static final int COLOR_FILL = 0;
    public static final int FONT = 1;
    public static final int COLOR_FONT = 2;
    public static final int COLOR_LINE = 3;
    public static final int COLOR_GRADIENT = 4;
    public static final int GRADIENT_POLICY = 5;
    public static final int JUMPLINK_STATUS = 6;
    public static final int JUMPLINK_REVERSE = 7;
    public static final int JUMPLINK_TYPE = 8;
    public static final int ROUTING_POLICY_DISTANCE = 9;
    public static final int ROUTING_POLICY_OBSTRUCTION = 10;
    public static final int ROUTING_STYLE = 11;
    public static final int SMOOTHNESS = 12;
    public static final int SHADOW = 13;
    public static final int ELEMENTICON = 14;
    public static final int QUALIFIEDNAME = 15;
    public static final int HEIGHT = 16;
    public static final int WIDTH = 17;
    public static final int COMPARTMENT_VISIBILITY = 18;
    public static final int COMPARTMENT_NAME_VISIBILITY = 19;
    public static final int LABEL_VISIBILITY = 20;
    public static final int LOCATION_X = 21;
    public static final int LOCATION_Y = 22;

    public static String getConstant(String elementName, int preferenceType) {
        StringBuffer sb = new StringBuffer();
        sb.append(elementName);
        sb.append(".");
        switch (preferenceType) {
            case 0: {
                sb.append(COLOR_FILL_CONSTANT);
                break;
            }
            case 1: {
                sb.append(FONT_CONSTANT);
                break;
            }
            case 2: {
                sb.append(COLOR_FONT_CONSTANT);
                break;
            }
            case 3: {
                sb.append(COLOR_LINE_CONSTANT);
                break;
            }
            case 4: {
                sb.append(COLOR_GRADIENT_CONSTANT);
                break;
            }
            case 5: {
                sb.append(GRADIENT_POLICY_CONSTANT);
                break;
            }
            case 6: {
                sb.append(JUMPLINK_STATUS_CONSTANT);
                break;
            }
            case 7: {
                sb.append(JUMPLINK_REVERSE_CONSTANT);
                break;
            }
            case 8: {
                sb.append(JUMPLINK_TYPE_CONSTANT);
                break;
            }
            case 9: {
                sb.append(ROUTING_POLICY_DISTANCE_CONSTANT);
                break;
            }
            case 10: {
                sb.append(ROUTING_POLICY_OBSTRUCTION_CONSTANT);
                break;
            }
            case 11: {
                sb.append(ROUTING_STYLE_CONSTANT);
                break;
            }
            case 12: {
                sb.append(SMOOTHNESS_CONSTANT);
                break;
            }
            case 13: {
                sb.append(SHADOW_CONSTANT);
                break;
            }
            case 14: {
                sb.append(ELEMENTICON_CONSTANT);
                break;
            }
            case 15: {
                sb.append(QUALIFIEDNAME_CONSTANT);
                break;
            }
            case 16: {
                sb.append(HEIGHT_CONSTANT);
                break;
            }
            case 17: {
                sb.append(WIDTH_CONSTANT);
                break;
            }
            case 18: {
                sb.append(COMPARTMENT_VISIBILITY_CONSTANT);
                break;
            }
            case 19: {
                sb.append(COMPARTMENT_NAME_VISIBILITY_CONSTANT);
                break;
            }
            case 20: {
                sb.append(LABEL_VISIBILITY_CONSTANT);
            }
            case 21: {
                sb.append(LOCATION_X_CONSTANT);
            }
            case 22: {
                sb.append(LOCATION_Y_CONSTANT);
            }
        }
        return sb.toString();
    }

    public static String getElementConstant(String elementName, int preferenceType) {
        return String.valueOf(DIAGRAM_ELEMENT) + PreferenceConstantHelper.getConstant(elementName, preferenceType);
    }

    public static String getCompartmentElementConstant(String elementName, String compartmentName, int preferenceType) {
        String tmp = PreferenceConstantHelper.getElementConstant(elementName, preferenceType);
        return tmp.replaceFirst("\\.", "_" + compartmentName + ".");
    }

    public static String getLabelElementConstant(String elementName, String labelRole, int preferenceType) {
        String tmp = PreferenceConstantHelper.getElementConstant(elementName, preferenceType);
        return tmp.replaceFirst("\\.", "_" + labelRole + ".");
    }

    public static String getPapyrusEditorConstant(int preferenceType) {
        return PreferenceConstantHelper.getConstant(PAPYRUS_EDITOR_PREFERENCE_PREFIX, preferenceType);
    }

    public static String getDiagramConstant(String diagramKind, int preferenceType) {
        return String.valueOf(DIAGRAM_PREFERENCE_PREFIX) + PreferenceConstantHelper.getConstant(diagramKind, preferenceType);
    }
}

