/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.definition;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.papyrus.profile.Message;
import org.eclipse.papyrus.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class ProfileRedefinition {
    public static void redefineProfile(Package thepackage, PapyrusDefinitionAnnotation definitionAnnotation) {
        if (thepackage instanceof Profile) {
            Profile profile = (Profile)thepackage;
            EPackage profileDefinition = profile.getDefinition();
            ArrayList<EClassifier> tempList = new ArrayList<EClassifier>();
            int i = 0;
            while (i < profileDefinition.getEClassifiers().size()) {
                tempList.add((EClassifier)profileDefinition.getEClassifiers().get(i));
                ++i;
            }
            for (EClassifier eclassifier : tempList) {
                if (!(eclassifier instanceof EClass) || ProfileRedefinition.isDataTypeDefinition(eclassifier)) continue;
                ProfileRedefinition.redefineEclass((EClass)eclassifier);
            }
            if (definitionAnnotation != null) {
                profile.getDefinition().getEAnnotations().add((Object)definitionAnnotation.convertToEAnnotation());
            }
        }
        for (Package p : thepackage.getNestedPackages()) {
            ProfileRedefinition.redefineProfile(p, definitionAnnotation);
        }
    }

    public static void redefineEclass(EClass eclass) {
        if (ProfileRedefinition.isADirectDefinition(eclass)) {
            EList eSuperTypes = eclass.getESuperTypes();
            ArrayList<EClass> superTypesList = new ArrayList<EClass>();
            int j = 0;
            while (j < eSuperTypes.size()) {
                superTypesList.add((EClass)eSuperTypes.get(j));
                ++j;
            }
            for (EClass currentSuperClass : superTypesList) {
                if (ProfileRedefinition.isADirectDefinition(currentSuperClass)) continue;
                EClass directSuperClass = (EClass)ProfileRedefinition.lookForDirectDefinitionFrom((EClassifier)currentSuperClass);
                eclass.getESuperTypes().remove((Object)currentSuperClass);
                eclass.getESuperTypes().add((Object)directSuperClass);
            }
            Iterator iterReference = eclass.getEReferences().iterator();
            ArrayList<EReference> referenceList = new ArrayList<EReference>();
            while (iterReference.hasNext()) {
                referenceList.add((EReference)iterReference.next());
            }
            Iterator refIterator = referenceList.iterator();
            while (refIterator.hasNext()) {
                ProfileRedefinition.redefineEReference((EReference)refIterator.next(), eclass.getEPackage());
            }
            Iterator eattIterator = eclass.getEAllAttributes().iterator();
            while (eattIterator.hasNext()) {
                ProfileRedefinition.redefineEAttribute((EAttribute)eattIterator.next(), eclass.getEPackage());
            }
        }
    }

    public static void redefineEReference(EReference eReference, EPackage profileDefinition) {
        EReference oldEOpposite = eReference.getEOpposite();
        EClassifier oldType = eReference.getEType();
        if (oldType instanceof EClass) {
            eReference.setContainment(false);
            if (!ProfileRedefinition.isDataTypeDefinition(oldType)) {
                eReference.setEType(ProfileRedefinition.lookForDirectDefinitionFrom((EClassifier)((EClass)oldType)));
                if (oldEOpposite != null) {
                    eReference.setEOpposite(ProfileRedefinition.lookForEquivalentEreference((EClass)eReference.getEType(), oldEOpposite));
                }
            }
        }
        if (ProfileRedefinition.isDataTypeDefinition(oldType)) {
            EAttribute eatt = ProfileRedefinition.createEAttribute(eReference.getEContainingClass(), eReference);
            eatt.setEType((EClassifier)ProfileRedefinition.createDataType(profileDefinition, (Type)ProfileRedefinition.getUMLClassifierFromDefinition(oldType)));
            eatt.setDefaultValue(eReference.getDefaultValue());
            eatt.setDefaultValueLiteral(eReference.getDefaultValueLiteral());
            eReference.getEContainingClass().getEStructuralFeatures().remove((Object)eReference);
        }
    }

    public static void redefineEAttribute(EAttribute eAttribute, EPackage profileDefinition) {
        EClassifier oldEType = eAttribute.getEType();
        if (ProfileRedefinition.isDataTypeDefinition(oldEType)) {
            eAttribute.setEType((EClassifier)ProfileRedefinition.createDataType(profileDefinition, (Type)ProfileRedefinition.getUMLClassifierFromDefinition(oldEType)));
        }
    }

    public static boolean isADirectDefinition(EClass eclass) {
        EAnnotation eAnnotation;
        if (eclass.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eclass.getEAnnotations().get(0)).getReferences().size() > 0) {
            Stereotype theStereotype;
            if (!(eAnnotation.getReferences().get(0) instanceof Stereotype)) {
                String errMsg = "Problem because of the definition of " + eclass.getName() + " in " + eclass.getEPackage().getNsURI();
                Message.error(errMsg);
            }
            if ((theStereotype = (Stereotype)eAnnotation.getReferences().get(0)).getDefinition().equals(eclass)) {
                return true;
            }
        }
        return false;
    }

    public static EClassifier lookForDirectDefinitionFrom(EClassifier eClassifier) {
        EAnnotation eAnnotation;
        if (eClassifier.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eClassifier.getEAnnotations().get(0)).getReferences().size() > 0) {
            Stereotype theStereotype = (Stereotype)eAnnotation.getReferences().get(0);
            return theStereotype.getDefinition();
        }
        return eClassifier;
    }

    private static EReference lookForEquivalentEreference(EClass eclass, EReference eReference) {
        for (EReference currentEReference : eclass.getEReferences()) {
            if (!currentEReference.getName().equals(eReference.getName()) || !currentEReference.getEType().getName().endsWith(eReference.getEType().getName())) continue;
            return currentEReference;
        }
        return null;
    }

    public static void cleanProfile(Package thePackage) {
        if (thePackage instanceof Profile) {
            Profile profile = (Profile)thePackage;
            EPackage profileDefinition = profile.getDefinition();
            ArrayList<EClassifier> tempList = new ArrayList<EClassifier>();
            int i = 0;
            while (i < profileDefinition.getEClassifiers().size()) {
                tempList.add((EClassifier)profileDefinition.getEClassifiers().get(i));
                ++i;
            }
            for (EClassifier eclassifier : tempList) {
                if (!(eclassifier instanceof EClass)) continue;
                if (ProfileRedefinition.isDataTypeDefinition(eclassifier)) {
                    profileDefinition.getEClassifiers().remove((Object)eclassifier);
                    continue;
                }
                if (ProfileRedefinition.isADirectDefinition((EClass)eclassifier)) continue;
                profileDefinition.getEClassifiers().remove((Object)eclassifier);
            }
        }
        for (Package p : thePackage.getNestedPackages()) {
            ProfileRedefinition.cleanProfile(p);
        }
    }

    public static EDataType createDataType(EPackage profileDefinition, Type currentUmlType) {
        for (EClassifier current : profileDefinition.getEClassifiers()) {
            if (!(current instanceof EDataType) || !current.getName().equals(currentUmlType.getName())) continue;
            current.setInstanceClassName("java.lang.String");
            return (EDataType)current;
        }
        EDataType dataTypeDef = EcoreFactory.eINSTANCE.createEDataType();
        dataTypeDef.setName(currentUmlType.getName());
        dataTypeDef.setInstanceClassName("java.lang.String");
        dataTypeDef.setSerializable(true);
        EAnnotation umlAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        umlAnnotation.setSource("http://www.eclipse.org/uml2/2.0.0/UML");
        umlAnnotation.getReferences().add((Object)currentUmlType);
        dataTypeDef.getEAnnotations().add((Object)umlAnnotation);
        profileDefinition.getEClassifiers().add((Object)dataTypeDef);
        return dataTypeDef;
    }

    public static EAttribute createEAttribute(EClass container, EReference eReference) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setEType(eReference.getEType());
        eAttribute.setName(eReference.getName());
        eAttribute.setChangeable(eReference.isChangeable());
        eAttribute.setLowerBound(eReference.getLowerBound());
        eAttribute.setUpperBound(eReference.getUpperBound());
        eAttribute.setOrdered(eReference.isOrdered());
        eAttribute.setDerived(eReference.isDerived());
        eAttribute.setTransient(eReference.isTransient());
        eAttribute.setUnique(eReference.isUnique());
        eAttribute.setUnsettable(eReference.isUnsettable());
        eAttribute.setVolatile(eReference.isVolatile());
        container.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    public static boolean isDataTypeDefinition(EClassifier eclass) {
        Classifier theClassifier;
        EAnnotation eAnnotation;
        return eclass.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eclass.getEAnnotations().get(0)).getReferences().size() > 0 && (theClassifier = (Classifier)eAnnotation.getReferences().get(0)) instanceof DataType && !(theClassifier instanceof Enumeration);
    }

    public static Classifier getUMLClassifierFromDefinition(EClassifier eclass) {
        EAnnotation eAnnotation;
        if (eclass.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eclass.getEAnnotations().get(0)).getReferences().size() > 0) {
            Classifier theClassifier = (Classifier)eAnnotation.getReferences().get(0);
            return theClassifier;
        }
        return null;
    }
}

