/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.tree.objects;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.profile.tree.objects.CompositeValueTreeObject;
import org.eclipse.papyrus.profile.tree.objects.DataTypeValueTreeObject;
import org.eclipse.papyrus.profile.tree.objects.EnumerationValueTreeObject;
import org.eclipse.papyrus.profile.tree.objects.MetaclassValueTreeObject;
import org.eclipse.papyrus.profile.tree.objects.ParentTreeObject;
import org.eclipse.papyrus.profile.tree.objects.PrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.profile.tree.objects.StereotypeValueTreeObject;
import org.eclipse.papyrus.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.profile.utils.Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppliedStereotypePropertyTreeObject
extends ParentTreeObject {
    private Property property;

    public AppliedStereotypePropertyTreeObject(AppliedStereotypeTreeObject parent, Property property) {
        super(parent);
        this.property = property;
    }

    public Stereotype getParentStereotype() {
        return ((AppliedStereotypeTreeObject)this.getParent()).getStereotype();
    }

    public Property getProperty() {
        return this.property;
    }

    public void reInitChilds() {
        this.children.clear();
        this.createChildren();
    }

    @Override
    protected void createChildren() {
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof EList) {
            EList values = (EList)value;
            for (Object currentValue : values) {
                ValueTreeObject vTO = this.createValueTreeObject(currentValue);
                this.addChild(vTO);
            }
        } else {
            ValueTreeObject vTO = this.createValueTreeObject(value);
            this.addChild(vTO);
        }
    }

    public Object getValue() {
        AppliedStereotypeTreeObject sTO = (AppliedStereotypeTreeObject)this.getParent();
        StereotypedElementTreeObject rTO = (StereotypedElementTreeObject)sTO.getParent();
        Stereotype st = sTO.getStereotype();
        Element elt = rTO.getElement();
        return elt.getValue(st, this.property.getName());
    }

    private ValueTreeObject createValueTreeObject(Object value) {
        Type type = this.property.getType();
        ValueTreeObject vTO = null;
        if (type instanceof PrimitiveType) {
            vTO = PrimitiveTypeValueTreeObject.createInstance(this, value);
        } else if (Util.isMetaclass(type)) {
            vTO = new MetaclassValueTreeObject(this, value);
        } else if (type instanceof Enumeration) {
            vTO = new EnumerationValueTreeObject(this, value);
        } else if (type instanceof DataType) {
            vTO = new DataTypeValueTreeObject(this, value);
        } else if (type instanceof Stereotype) {
            vTO = new StereotypeValueTreeObject(this, value);
        } else if (type instanceof Class && !(type instanceof Stereotype) && this.property.isComposite()) {
            vTO = new CompositeValueTreeObject(this, value);
        }
        return vTO;
    }

    public Object appendMV(Object newValue) {
        Object existingValue;
        Stereotype stereotype = ((AppliedStereotypeTreeObject)this.getParent()).getStereotype();
        Element element = ((StereotypedElementTreeObject)this.getParent().getParent()).getElement();
        if (this.property.isMultivalued() && (existingValue = element.getValue(stereotype, this.property.getName())) instanceof EList) {
            EList existingValueList = (EList)existingValue;
            BasicEList valueList = new BasicEList();
            valueList.addAll((Collection)existingValueList);
            valueList.add(newValue);
            return valueList;
        }
        return newValue;
    }

    protected <T> void removeSelected(List<T> proposalList, T oldValue) {
        if (this.property.isMultivalued()) {
            EList values = (EList)this.getValue();
            if (values != null) {
                proposalList.removeAll((Collection<?>)values);
            }
            if (oldValue != null) {
                proposalList.add(oldValue);
            }
        }
    }

    public void updateValue(final Object newValue) {
        TransactionalEditingDomain domain = EditorUtils.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(domain, "Edit Stereotype Property Value"){

            protected void doExecute() {
                Stereotype stereotype = ((AppliedStereotypeTreeObject)AppliedStereotypePropertyTreeObject.this.getParent()).getStereotype();
                Element element = ((StereotypedElementTreeObject)AppliedStereotypePropertyTreeObject.this.getParent().getParent()).getElement();
                Property property = AppliedStereotypePropertyTreeObject.this.getProperty();
                element.setValue(stereotype, property.getName(), newValue);
            }
        };
        domain.getCommandStack().execute((Command)command);
    }
}

