/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.tree.objects;

import java.util.ArrayList;
import org.eclipse.papyrus.profile.tree.objects.TreeObject;

public abstract class ParentTreeObject
extends TreeObject {
    protected ArrayList<TreeObject> children;

    public ParentTreeObject(ParentTreeObject parent) {
        super(parent);
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
    }

    public void moveChildUp(TreeObject child) {
        if (this.children == null) {
            return;
        }
        int index = this.children.indexOf(child);
        if (index < 1) {
            return;
        }
        TreeObject tmp = this.children.get(index - 1);
        this.children.set(index - 1, child);
        this.children.set(index, tmp);
    }

    public void moveChildDown(TreeObject child) {
        if (this.children == null) {
            return;
        }
        int index = this.children.indexOf(child);
        if (index == -1 || index >= this.children.size() - 1) {
            return;
        }
        TreeObject tmp = this.children.get(index + 1);
        this.children.set(index + 1, child);
        this.children.set(index, tmp);
    }

    public TreeObject[] getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            this.createChildren();
        }
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    protected abstract void createChildren();
}

