/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.compositeforview;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.profile.ui.compositeforview.AppliedStereotypePropertyCompositeWithView;
import org.eclipse.papyrus.profile.ui.compositeforview.IViewComposite;
import org.eclipse.papyrus.profile.ui.compositeforview.ProfileElementWithDisplayContentProvider;
import org.eclipse.papyrus.profile.ui.compositeforview.ProfileElementWithDisplayLabelProvider;
import org.eclipse.papyrus.profile.ui.compositesformodel.AppliedStereotypeCompositeOnModel;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCompositeWithView
extends AppliedStereotypeCompositeOnModel
implements IViewComposite {
    protected ISelection selection;
    protected AppliedStereotypePropertyCompositeWithView propertyComposite;
    private EModelElement diagramElement;

    public AppliedStereotypeCompositeWithView(Composite parent) {
        super(parent);
        this.setBackground(JFaceColors.getBannerBackground((Display)parent.getDisplay()));
    }

    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementWithDisplayContentProvider(this.diagramElement));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfileElementWithDisplayLabelProvider());
        this.refresh();
        return this;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void setDiagramElement(EModelElement diagramElement) {
        this.diagramElement = diagramElement;
        ((ProfileElementWithDisplayContentProvider)this.treeViewer.getContentProvider()).setDiagramElement(diagramElement);
    }

    public void setPropertyComposite(AppliedStereotypePropertyCompositeWithView propertyComposite) {
        this.propertyComposite = propertyComposite;
    }

    public Element getSelected() {
        return this.getElement();
    }

    public void addButtonPressed() {
        super.addButtonPressed();
    }

    public void applyStereotype(Element elt, final Stereotype st) {
        super.applyStereotype(elt, st);
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)AppliedStereotypeCompositeWithView.this.getDomain(), (EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            AppliedStereotypeCompositeWithView.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void unapplyStereotype(Element elt, final Stereotype st) {
        super.unapplyStereotype(elt, st);
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)AppliedStereotypeCompositeWithView.this.getDomain(), (EModelElement)AppliedStereotypeCompositeWithView.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            AppliedStereotypeCompositeWithView.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeButtonPressed() {
        this.superRemoveButton();
    }

    private void superRemoveButton() {
        super.removeButtonPressed();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event == null) {
            this.propertyComposite.setInput(null);
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)event.getSelection();
        Object selection = structSelection.getFirstElement();
        if (selection instanceof AppliedStereotypePropertyTreeObject) {
            this.propertyComposite.setInput((AppliedStereotypePropertyTreeObject)selection);
        } else {
            this.propertyComposite.setInput(null);
        }
    }
}

