/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.profile.ImageManager;
import org.eclipse.papyrus.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.profile.utils.Util;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Profile;

public class DefinitionHistoryDialog
extends TitleAreaDialog {
    public static final String PROFILE_ANNOTATION_IMG = "resources/icons/wizban/Annotation.gif";
    protected Profile profile;
    List<PapyrusDefinitionAnnotation> oldVersionAnnotations = new ArrayList<PapyrusDefinitionAnnotation>();

    public DefinitionHistoryDialog(Shell parentShell, Profile profile) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.profile = profile;
        this.computeHistoryAnnotations();
    }

    private void computeHistoryAnnotations() {
        this.oldVersionAnnotations = Util.getAllPapyrusDefinitionAnnotation(this.profile);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.setTitle("Profile definition history");
        this.setTitleImage(ImageManager.getImage(PROFILE_ANNOTATION_IMG));
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parentComposite.getFont());
        Composite tableArea = this.createTableArea(composite);
        GridData gd = new GridData(4, 4, true, true);
        tableArea.setLayoutData((Object)gd);
        DefinitionHistoryDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private Composite createTableArea(Composite composite) {
        Composite parent = new Composite(composite, 4);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Font font = composite.getFont();
        TableViewer viewer = new TableViewer(parent, 68354);
        Table table = viewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setFont(font);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 450;
        gridData.heightHint = 300;
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.setContentProvider((IContentProvider)new DefinitionHistoryContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DefinitionHistoryTableLabelProvider());
        this.createTableColumn(table, 20, "version", true, 0x1000000);
        this.createTableColumn(table, 40, "author", true, 0x1000000);
        this.createTableColumn(table, 30, "date", true, 0x1000000);
        this.createTableColumn(table, 30, "comment", true, 16384);
        this.createTableColumn(table, 50, "copyright", true, 16384);
        viewer.setContentProvider((IContentProvider)new DefinitionHistoryContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DefinitionHistoryTableLabelProvider());
        viewer.setInput((Object)this.profile);
        return parent;
    }

    protected TableColumn createTableColumn(Table table, int weight, String title, boolean resizable, int style) {
        ((TableLayout)table.getLayout()).addColumnData((ColumnLayoutData)new ColumnWeightData(weight));
        TableColumn tc = new TableColumn(table, style);
        tc.setResizable(true);
        tc.setText(title);
        return tc;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText("Profile Definition");
    }

    public class DefinitionHistoryContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Profile) {
                EAnnotation eAnnotation = ((Profile)inputElement).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
                if (eAnnotation != null) {
                    EList definitions = eAnnotation.getContents();
                    ArrayList<PapyrusDefinitionAnnotation> elements = new ArrayList<PapyrusDefinitionAnnotation>();
                    ListIterator it = definitions.listIterator();
                    while (it.hasNext()) {
                        EPackage object = (EPackage)it.next();
                        EAnnotation annotation = object.getEAnnotation("PapyrusVersion");
                        if (annotation == null) {
                            elements.add(0, PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION);
                            continue;
                        }
                        elements.add(0, PapyrusDefinitionAnnotation.parseEAnnotation(annotation));
                    }
                    return elements.toArray();
                }
                return new Object[0];
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class DefinitionHistoryTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PapyrusDefinitionAnnotation) {
                return this.getColumnText((PapyrusDefinitionAnnotation)element, columnIndex);
            }
            return "naa";
        }

        public String getColumnText(PapyrusDefinitionAnnotation annotation, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return annotation.getVersion().toString();
                }
                case 1: {
                    return annotation.getAuthor();
                }
                case 2: {
                    return annotation.getDate();
                }
                case 3: {
                    return annotation.getComment();
                }
                case 4: {
                    return annotation.getCopyright();
                }
            }
            return "unknown";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

