/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.papyrus.profile.ui.dialogs.IListViewer;

public class ElementList {
    private ArrayList elements = new ArrayList();
    private Set changeListeners = new HashSet();

    public ElementList() {
        this.initData();
    }

    protected void initData() {
    }

    public ArrayList getElements() {
        return this.elements;
    }

    public void addElement(Object element) {
        this.elements.add(this.elements.size(), element);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IListViewer)iterator.next()).addElement(element);
        }
    }

    public void removeElement(Object element) {
        this.elements.remove(element);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IListViewer)iterator.next()).removeElement(element);
        }
    }

    public void moveElementUp(Object element) {
        int index = this.elements.indexOf(element);
        if (index > 0) {
            this.elements.remove(element);
            this.elements.add(index - 1, element);
        }
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IListViewer)iterator.next()).updateElement(element);
        }
    }

    public void moveElementDown(Object element) {
        int index = this.elements.indexOf(element);
        if (index >= 0 && index < this.elements.size() - 1) {
            this.elements.remove(element);
            this.elements.add(index + 1, element);
        }
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IListViewer)iterator.next()).updateElement(element);
        }
    }

    public void elementChanged(Object element) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IListViewer)iterator.next()).updateElement(element);
        }
    }

    public boolean contains(Object element) {
        return this.elements.contains(element);
    }

    public void removeChangeListener(IListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

