/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.section;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.umlutils.ElementUtil;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeKindAppearanceSection
extends AbstractPropertySection {
    private static final String VERTICAL = "Vertical";
    private static final String HORIZONTAL = "Horizontal";
    private static final String TEXT_AND_ICON = "Text and Icon";
    private static final String SHAPE = "Shape";
    private static final String ICON = "Icon";
    private static final String TEXT = "Text";
    private String stereotypePlacePresentation = "Compartment";
    private EModelElement diagramElement;
    private CLabel stereotypeAppearance;
    private CLabel stereotypeTextAlignement;
    private CCombo comboStereotypeAppearance;
    private CCombo comboStereotypeAlignement;
    private SelectionListener comboStereotypeAppearanceListener;
    private SelectionListener comboStereotypeAlignementListener;
    private TransactionalEditingDomain domain;
    private CLabel stereotypeDisplayPlace;
    private CCombo comboStereotypeDisplayPlace;
    private SelectionListener comboStereotypeDisplayListener;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.stereotypeAppearance = this.getWidgetFactory().createCLabel(composite, "Stereotype Display:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        this.stereotypeAppearance.setLayoutData((Object)data);
        this.comboStereotypeAppearance = this.getWidgetFactory().createCCombo(composite, 2056);
        this.comboStereotypeAppearance.add(TEXT);
        this.comboStereotypeAppearance.add(ICON);
        this.comboStereotypeAppearance.add(TEXT_AND_ICON);
        this.comboStereotypeAppearance.add(SHAPE);
        data = new FormData();
        data.left = new FormAttachment(0, 135);
        data.top = new FormAttachment(0, 0);
        this.comboStereotypeAppearance.setLayoutData((Object)data);
        this.comboStereotypeAppearanceListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AppliedStereotypeKindAppearanceSection.this.diagramElement != null && ((View)AppliedStereotypeKindAppearanceSection.this.diagramElement).getElement() != null) {
                    Element elt = (Element)((View)AppliedStereotypeKindAppearanceSection.this.diagramElement).getElement();
                    Stereotype stereotype = AppliedStereotypeHelper.getFirstDisplayedStereotype((EModelElement)AppliedStereotypeKindAppearanceSection.this.diagramElement, (Element)elt);
                    boolean hasIcons = ElementUtil.hasIcons((Element)elt, (Stereotype)stereotype);
                    boolean hasShapes = ElementUtil.hasShapes((Element)elt, (Stereotype)stereotype);
                    String appliedStereotypeKind = "HorizontalStereo";
                    String stereotypeAppearance = AppliedStereotypeKindAppearanceSection.this.comboStereotypeAppearance.getText();
                    if (stereotypeAppearance.equals(AppliedStereotypeKindAppearanceSection.TEXT)) {
                        appliedStereotypeKind = "HorizontalStereo";
                    } else if (stereotypeAppearance.equals(AppliedStereotypeKindAppearanceSection.ICON) && hasIcons) {
                        appliedStereotypeKind = "IconStereotype";
                    } else if (stereotypeAppearance.equals(AppliedStereotypeKindAppearanceSection.TEXT_AND_ICON) && hasIcons) {
                        appliedStereotypeKind = "TextIconStereotype";
                    } else if (stereotypeAppearance.equals(AppliedStereotypeKindAppearanceSection.SHAPE) && hasShapes) {
                        appliedStereotypeKind = "ImageStereotype";
                    }
                    String stereotypetoDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)AppliedStereotypeKindAppearanceSection.this.diagramElement);
                    RecordingCommand command = AppliedStereotypeHelper.getAppliedStereotypeToDisplayCommand((TransactionalEditingDomain)AppliedStereotypeKindAppearanceSection.this.domain, (EModelElement)AppliedStereotypeKindAppearanceSection.this.diagramElement, (String)stereotypetoDisplay, (String)appliedStereotypeKind);
                    AppliedStereotypeKindAppearanceSection.this.domain.getCommandStack().execute((Command)command);
                    AppliedStereotypeKindAppearanceSection.this.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.comboStereotypeAppearance.addSelectionListener(this.comboStereotypeAppearanceListener);
        this.stereotypeTextAlignement = this.getWidgetFactory().createCLabel(composite, "Text Alignement:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.comboStereotypeAppearance, 40);
        data.top = new FormAttachment((Control)this.comboStereotypeAppearance, 1, 0x1000000);
        this.stereotypeTextAlignement.setLayoutData((Object)data);
        this.comboStereotypeAlignement = this.getWidgetFactory().createCCombo(composite, 2056);
        this.comboStereotypeAlignement.add(HORIZONTAL);
        this.comboStereotypeAlignement.add(VERTICAL);
        data = new FormData();
        data.left = new FormAttachment((Control)this.stereotypeTextAlignement, 0);
        data.top = new FormAttachment(0, 0);
        this.comboStereotypeAlignement.setLayoutData((Object)data);
        this.comboStereotypeAlignementListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AppliedStereotypeKindAppearanceSection.this.diagramElement != null && ((View)AppliedStereotypeKindAppearanceSection.this.diagramElement).getElement() != null) {
                    String appliedStereotypeKind = "HorizontalStereo";
                    if (AppliedStereotypeKindAppearanceSection.this.comboStereotypeAlignement.getText().equals(AppliedStereotypeKindAppearanceSection.HORIZONTAL)) {
                        appliedStereotypeKind = "HorizontalStereo";
                    } else if (AppliedStereotypeKindAppearanceSection.this.comboStereotypeAlignement.getText().equals(AppliedStereotypeKindAppearanceSection.VERTICAL)) {
                        appliedStereotypeKind = "VerticalStereo";
                    }
                    String stereotypetoDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)AppliedStereotypeKindAppearanceSection.this.diagramElement);
                    RecordingCommand command = AppliedStereotypeHelper.getAppliedStereotypeToDisplayCommand((TransactionalEditingDomain)AppliedStereotypeKindAppearanceSection.this.domain, (EModelElement)AppliedStereotypeKindAppearanceSection.this.diagramElement, (String)stereotypetoDisplay, (String)appliedStereotypeKind);
                    AppliedStereotypeKindAppearanceSection.this.domain.getCommandStack().execute((Command)command);
                    AppliedStereotypeKindAppearanceSection.this.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.comboStereotypeAlignement.addSelectionListener(this.comboStereotypeAlignementListener);
        this.stereotypeDisplayPlace = this.getWidgetFactory().createCLabel(composite, "Display Place:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.comboStereotypeAlignement, 40);
        data.top = new FormAttachment((Control)this.comboStereotypeAlignement, 1, 0x1000000);
        this.stereotypeDisplayPlace.setLayoutData((Object)data);
        this.comboStereotypeDisplayPlace = this.getWidgetFactory().createCCombo(composite, 2056);
        this.comboStereotypeDisplayPlace.add("Comment");
        this.comboStereotypeDisplayPlace.add("Compartment");
        this.comboStereotypeDisplayPlace.add("With brace");
        data = new FormData();
        data.left = new FormAttachment((Control)this.stereotypeDisplayPlace, 0);
        data.top = new FormAttachment(0, 0);
        this.comboStereotypeDisplayPlace.setLayoutData((Object)data);
        this.comboStereotypeDisplayListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AppliedStereotypeKindAppearanceSection.this.diagramElement != null) {
                    AppliedStereotypeKindAppearanceSection.this.stereotypePlacePresentation = AppliedStereotypeKindAppearanceSection.this.comboStereotypeDisplayPlace.getText();
                    RecordingCommand command = AppliedStereotypeHelper.getSetAppliedStereotypePropertiesLocalizationCommand((TransactionalEditingDomain)AppliedStereotypeKindAppearanceSection.this.domain, (EModelElement)AppliedStereotypeKindAppearanceSection.this.diagramElement, (String)AppliedStereotypeKindAppearanceSection.this.stereotypePlacePresentation);
                    AppliedStereotypeKindAppearanceSection.this.domain.getCommandStack().execute((Command)command);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.comboStereotypeDisplayPlace.addSelectionListener(this.comboStereotypeDisplayListener);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            IContributedContentsView contributedView;
            Object input = ((IStructuredSelection)selection).getFirstElement();
            this.diagramElement = input instanceof GraphicalEditPart && ((GraphicalEditPart)input).getModel() instanceof View ? (EModelElement)((GraphicalEditPart)input).getModel() : null;
            if (part instanceof ContentOutline && (contributedView = (IContributedContentsView)((ContentOutline)part).getAdapter(IContributedContentsView.class)) != null) {
                part = contributedView.getContributingPart();
            }
            if (part instanceof IMultiDiagramEditor) {
                IMultiDiagramEditor editor = (IMultiDiagramEditor)part;
                this.domain = EditorUtils.getTransactionalEditingDomain();
            } else {
                this.domain = null;
            }
        }
    }

    public void refresh() {
        this.refreshStereotypeAppearance();
        this.refreshStereotypeAlignment();
        this.refreshStereotypeDisplayLocation();
    }

    private void refreshStereotypeDisplayLocation() {
        if (this.comboStereotypeDisplayPlace != null && !this.comboStereotypeDisplayPlace.isDisposed()) {
            this.comboStereotypeDisplayPlace.removeSelectionListener(this.comboStereotypeDisplayListener);
            if (this.diagramElement != null) {
                if (this.isComboEnabled()) {
                    this.comboStereotypeDisplayPlace.setEnabled(true);
                    this.stereotypePlacePresentation = AppliedStereotypeHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)this.diagramElement);
                    this.comboStereotypeDisplayPlace.setText(this.stereotypePlacePresentation);
                } else {
                    this.comboStereotypeDisplayPlace.setEnabled(false);
                    this.comboStereotypeDisplayPlace.setText(this.stereotypePlacePresentation);
                }
            }
            this.comboStereotypeDisplayPlace.addSelectionListener(this.comboStereotypeDisplayListener);
        }
    }

    private boolean isComboEnabled() {
        return !AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)this.diagramElement).equals("");
    }

    private void refreshStereotypeAlignment() {
        if (!this.comboStereotypeAlignement.isDisposed()) {
            this.comboStereotypeAlignement.removeSelectionListener(this.comboStereotypeAlignementListener);
            if (this.diagramElement != null) {
                if (((View)this.diagramElement).getElement() != null && ((Element)((View)this.diagramElement).getElement()).getAppliedStereotypes().size() != 0) {
                    this.comboStereotypeAlignement.setEnabled(true);
                    String stereotypePresentation = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.diagramElement);
                    if (stereotypePresentation != null) {
                        Element elt = (Element)((View)this.diagramElement).getElement();
                        Stereotype stereotype = AppliedStereotypeHelper.getFirstDisplayedStereotype((EModelElement)this.diagramElement, (Element)elt);
                        boolean hasIcons = ElementUtil.hasIcons((Element)elt, (Stereotype)stereotype);
                        boolean hasShapes = ElementUtil.hasShapes((Element)elt, (Stereotype)stereotype);
                        if (stereotypePresentation.equals("IconStereotype") && hasIcons) {
                            this.comboStereotypeAlignement.setEnabled(false);
                        } else if (stereotypePresentation.equals("TextIconStereotype") && hasIcons) {
                            this.comboStereotypeAlignement.setEnabled(true);
                        } else if (stereotypePresentation.equals("ImageStereotype") && hasShapes) {
                            this.comboStereotypeAlignement.setEnabled(false);
                        } else {
                            this.comboStereotypeAlignement.setEnabled(true);
                        }
                        if (stereotypePresentation.equals("HorizontalStereo")) {
                            this.comboStereotypeAlignement.setText(HORIZONTAL);
                        } else if (stereotypePresentation.equals("VerticalStereo")) {
                            this.comboStereotypeAlignement.setText(VERTICAL);
                        } else {
                            this.comboStereotypeAlignement.setText(HORIZONTAL);
                        }
                    } else {
                        this.comboStereotypeAlignement.setText(HORIZONTAL);
                    }
                } else {
                    this.comboStereotypeAlignement.setText("");
                    this.comboStereotypeAlignement.setEnabled(false);
                }
            }
            this.comboStereotypeAlignement.addSelectionListener(this.comboStereotypeAlignementListener);
        }
    }

    private void refreshStereotypeAppearance() {
        if (!this.comboStereotypeAppearance.isDisposed()) {
            this.comboStereotypeAppearance.removeSelectionListener(this.comboStereotypeAppearanceListener);
            if (this.diagramElement != null) {
                if (((View)this.diagramElement).getElement() != null && ((Element)((View)this.diagramElement).getElement()).getAppliedStereotypes().size() != 0) {
                    this.comboStereotypeAppearance.setEnabled(true);
                    String stereotypePresentation = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.diagramElement);
                    if (stereotypePresentation != null) {
                        Element elt = (Element)((View)this.diagramElement).getElement();
                        Stereotype stereotype = AppliedStereotypeHelper.getFirstDisplayedStereotype((EModelElement)this.diagramElement, (Element)elt);
                        boolean hasIcons = ElementUtil.hasIcons((Element)elt, (Stereotype)stereotype);
                        boolean hasShapes = ElementUtil.hasShapes((Element)elt, (Stereotype)stereotype);
                        if (stereotypePresentation.equals("IconStereotype") && hasIcons) {
                            this.comboStereotypeAppearance.setText(ICON);
                        } else if (stereotypePresentation.equals("TextIconStereotype") && hasIcons) {
                            this.comboStereotypeAppearance.setText(TEXT_AND_ICON);
                        } else if (stereotypePresentation.equals("ImageStereotype") && hasShapes) {
                            this.comboStereotypeAppearance.setText(SHAPE);
                        } else {
                            this.comboStereotypeAppearance.setText(TEXT);
                        }
                    } else {
                        this.comboStereotypeAppearance.setText(TEXT);
                    }
                } else {
                    this.comboStereotypeAppearance.setText("");
                    this.comboStereotypeAppearance.setEnabled(false);
                }
            }
            this.comboStereotypeAppearance.addSelectionListener(this.comboStereotypeAppearanceListener);
        }
    }

    public void dispose() {
        if (this.comboStereotypeAppearance != null && !this.comboStereotypeAppearance.isDisposed()) {
            this.comboStereotypeAppearance.removeSelectionListener(this.comboStereotypeAppearanceListener);
        }
        if (this.comboStereotypeAlignement != null && !this.comboStereotypeAlignement.isDisposed()) {
            this.comboStereotypeAlignement.removeSelectionListener(this.comboStereotypeAlignementListener);
        }
        if (this.comboStereotypeDisplayPlace != null && !this.comboStereotypeDisplayPlace.isDisposed()) {
            this.comboStereotypeDisplayPlace.removeSelectionListener(this.comboStereotypeDisplayListener);
        }
        if (this.diagramElement != null) {
            this.diagramElement.eAdapters().remove((Object)this);
        }
        super.dispose();
    }
}

