/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.section;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.profile.ui.compositeforview.AppliedStereotypeCompositeWithView;
import org.eclipse.papyrus.profile.ui.compositeforview.AppliedStereotypePropertyCompositeWithView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;

public class AppliedStereotypeSectionWithView
extends AbstractPropertySection {
    private AppliedStereotypeCompositeWithView appliedStereotypeComposite;
    private AppliedStereotypePropertyCompositeWithView propertyComposite;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.appliedStereotypeComposite = new AppliedStereotypeCompositeWithView(parent);
        this.appliedStereotypeComposite.createContent(parent, this.getWidgetFactory());
        this.propertyComposite = new AppliedStereotypePropertyCompositeWithView(parent, this.appliedStereotypeComposite);
        this.propertyComposite.createContent(parent, this.getWidgetFactory());
        this.appliedStereotypeComposite.setPropertyComposite(this.propertyComposite);
    }

    public void refresh() {
        this.appliedStereotypeComposite.refresh();
        this.propertyComposite.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            if (input instanceof GraphicalEditPart && ((GraphicalEditPart)input).getModel() instanceof View) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)input;
                View view = (View)graphicalEditPart.getModel();
                Element UMLElement = (Element)view.getElement();
                if (UMLElement != null) {
                    this.appliedStereotypeComposite.setDiagramElement((EModelElement)view);
                    this.propertyComposite.setDiagramElement((EModelElement)view);
                    this.appliedStereotypeComposite.setElement(UMLElement);
                    this.appliedStereotypeComposite.setInput(new StereotypedElementTreeObject(UMLElement));
                }
            } else {
                EObject eobject = this.resolveSemanticObject(input);
                if (eobject instanceof Element) {
                    Element UMLElement = (Element)eobject;
                    this.appliedStereotypeComposite.setDiagramElement(null);
                    this.appliedStereotypeComposite.setElement(UMLElement);
                    this.appliedStereotypeComposite.setInput(new StereotypedElementTreeObject(UMLElement));
                }
            }
        }
    }

    private EObject resolveSemanticObject(Object object) {
        IAdaptable adaptable;
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (object instanceof IAdaptable && (adaptable = (IAdaptable)object).getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.appliedStereotypeComposite != null) {
            this.appliedStereotypeComposite.disposeListeners();
        }
        if (this.propertyComposite != null) {
            this.propertyComposite.disposeListeners();
        }
    }
}

