/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Remi Schnekenburger (CEA LIST) remi.schnekenburger@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.swt.SWT;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * factory for property editor descriptors
 */
public class ComboPropertyEditorDescriptorFactory implements IPropertyEditorDescriptorFactory {

	/**
	 * {@inheritDoc}
	 */
	public PropertyEditorDescriptor createEditorDescriptor(Node editorNode) {
		String identifier = "";
		String label = "";
		String tooltipText = "";
		int labelPosition = SWT.LEFT;
		ImageDescriptor imageDescriptor = null;

		// retrieve id, label, label position and tooltipText
		NamedNodeMap attributes = editorNode.getAttributes();
		if(attributes != null) {
			for(int i = 0; i < attributes.getLength(); i++) {
				Node attribute = attributes.item(i);
				String nodeName = attribute.getNodeName();
				if("label".equals(nodeName)) {
					label = attribute.getNodeValue();
				} else if("labelPosition".equals(nodeName)) {
					labelPosition = Integer.parseInt(attribute.getNodeValue());
				} else if("id".equals(nodeName)) {
					identifier = attribute.getNodeValue();
				} else if("tooltip".equals(nodeName)) {
					tooltipText = attribute.getNodeValue();
				}
			}
		}

		// retrieve icon
		NodeList children = editorNode.getChildNodes();
		for(int i = 0; i < children.getLength(); i++) {
			Node child = children.item(i);
			if("icon".equals(child.getNodeName())) {
				NamedNodeMap iconAttributes = child.getAttributes();
				if(iconAttributes != null) {
					// retrieve plugin id and path
					for(int j = 0; j < iconAttributes.getLength(); j++) {
						Node pluginIDNode = iconAttributes.getNamedItem("pluginID");
						Node pathNode = iconAttributes.getNamedItem("path");
						if(pluginIDNode != null && pathNode != null) {
							imageDescriptor = Activator.imageDescriptorFromPlugin(pluginIDNode.getNodeValue(), pathNode.getNodeValue());
						}
					}
				}
			}
		}

		return new ComboPropertyEditorDescriptor(identifier, label, labelPosition, tooltipText, imageDescriptor);
	}
}
