/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.uml.modelhandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.controller.EMFPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.uml.Activator;
import org.eclipse.papyrus.properties.runtime.uml.modelhandler.AssociationEndNavigationHandlerState;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEndNavigationModelHandler
implements IEMFModelHandler {
    private final List<String> availableValues = Arrays.asList("true", "false");
    public static final String ID = "AssociationEndNavigation";

    public void setValueInModel(EObject objectToEdit, Object newValue) {
        if (!(objectToEdit instanceof Property)) {
            Activator.log.warn("the object to edit is not a Property");
            return;
        }
        boolean isNavigable = Boolean.parseBoolean((String)newValue);
        Property property = (Property)objectToEdit;
        Association association = property.getAssociation();
        if (association == null) {
            Activator.log.warn("the property is not a member end of an association");
            return;
        }
        EReference feature = UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd();
        ArrayList<Property> attributeList = new ArrayList<Property>();
        attributeList.addAll((Collection<Property>)association.getNavigableOwnedEnds());
        if (isNavigable) {
            attributeList.add(property);
        } else {
            attributeList.remove(property);
        }
        association.eSet((EStructuralFeature)feature, attributeList);
    }

    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)descriptor).setAvailableValues((List)this.getAvailableValues(null));
        } else {
            Activator.log.warn(descriptor + "could not be completed.");
        }
    }

    public Object getValueToEdit(EObject objectToEdit) {
        if (!(objectToEdit instanceof Property)) {
            Activator.log.warn("the object to edit is not a Property");
            return "";
        }
        Property property = (Property)objectToEdit;
        Association association = property.getAssociation();
        if (association == null) {
            Activator.log.warn("the property is not a member end of an association");
            return "";
        }
        if (association.getNavigableOwnedEnds().contains((Object)property)) {
            return "true";
        }
        return "false";
    }

    public boolean isChangeable(List<? extends EObject> objectsToEdit) {
        return true;
    }

    public String getId() {
        return ID;
    }

    public String getText() {
        return "AssociationEndNavigationHandler";
    }

    public Image getImage() {
        return Activator.getImage("/icons/ModelHandler.gif");
    }

    public AssociationEndNavigationHandlerState createState(boolean readOnly) {
        return new AssociationEndNavigationHandlerState(this, readOnly);
    }

    public List<String> getAvailableValues(EObject objects) {
        return this.availableValues;
    }

    public void handleNotifyChange(Notification notification, List<? extends EObject> objects, EMFPropertyEditorController adapter) {
        Object notificationFeature = notification.getFeature();
        if (!UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd().equals(notificationFeature)) {
            return;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                adapter.refreshDisplay();
            }
        }
    }

    public void addListenersToModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            Association association;
            eObject.eAdapters().add((Object)controller);
            if (!(eObject instanceof Property) || (association = ((Property)eObject).getAssociation()) == null) continue;
            association.eAdapters().add((Object)controller);
        }
    }

    public void removeListenersFromModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            Association association;
            eObject.eAdapters().remove((Object)controller);
            if (!(eObject instanceof Property) || (association = ((Property)eObject).getAssociation()) == null) continue;
            association.eAdapters().remove((Object)controller);
        }
    }

    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        return null;
    }

    public boolean canCreateValueOperations(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getDeleteValueOperation(List<? extends EObject> objectsToEdit, Composite parent, List<Integer> indexes) {
        return null;
    }

    public boolean canCreateDeleteValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getEditValueOperation(List<? extends EObject> objectsToEdit, int index, Composite parent, Object value) {
        return null;
    }

    public boolean canCreateEditValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        return null;
    }

    public boolean canCreateMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        return false;
    }

    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        if (!(objectToEdit instanceof Property)) {
            Activator.log.warn("the object to edit is not a Property");
            return null;
        }
        boolean isNavigable = Boolean.parseBoolean((String)newValue);
        Property property = (Property)objectToEdit;
        Association association = property.getAssociation();
        if (association == null) {
            Activator.log.warn("the property is not a member end of an association");
            return null;
        }
        EReference feature = UMLPackage.eINSTANCE.getAssociation_NavigableOwnedEnd();
        ArrayList<Property> attributeList = new ArrayList<Property>();
        attributeList.addAll((Collection<Property>)association.getNavigableOwnedEnds());
        if (isNavigable) {
            attributeList.add(property);
        } else {
            attributeList.remove(property);
        }
        return new SetRequest[]{new SetRequest(domain, (EObject)association, (EStructuralFeature)feature, attributeList)};
    }
}

