/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.uml.modelhandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.controller.EMFPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.uml.Activator;
import org.eclipse.papyrus.properties.runtime.uml.Messages;
import org.eclipse.papyrus.properties.runtime.uml.modelhandler.AssociationEndOwnerHandlerState;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEndOwnerModelHandler
implements IEMFModelHandler {
    private final List<String> availableValues = Arrays.asList(Messages.AssociationEndOwnerModelHandler_ComboValue_Association, Messages.AssociationEndOwnerModelHandler_ComboValue_Class);
    public static final String ID = "AssociationEndOwner";

    public void setValueInModel(EObject objectToEdit, Object newValue) {
        if (!(newValue instanceof String)) {
            Activator.log.warn("the new value for the association end owner handler was no a String");
            return;
        }
        if (!(objectToEdit instanceof Property)) {
            Activator.log.warn("the object to edit is not a Property");
            return;
        }
        Property property = (Property)objectToEdit;
        Association association = property.getAssociation();
        if (association == null) {
            Activator.log.warn("the property is not a member end of an association");
            return;
        }
        String value = (String)newValue;
        Type owner = null;
        if (Messages.AssociationEndOwnerModelHandler_ComboValue_Class.equals(value)) {
            if (!(property.getOwner() instanceof Association)) {
                return;
            }
            EList ownerList = association.getEndTypes();
            owner = ((Type)ownerList.get(0)).equals(property.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
            EReference feature = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
            if (owner instanceof Class) {
                ArrayList<Property> attributeList = new ArrayList<Property>();
                attributeList.addAll((Collection<Property>)((Class)owner).getAttributes());
                attributeList.add(property);
                ((Class)owner).eSet((EStructuralFeature)feature, attributeList);
                return;
            }
            Activator.log.error("The owner was not a class: " + owner, null);
            return;
        }
        EReference feature = UMLPackage.eINSTANCE.getAssociation_OwnedEnd();
        ArrayList<Property> attributeList = new ArrayList<Property>();
        attributeList.addAll((Collection<Property>)association.getOwnedEnds());
        attributeList.add(property);
        association.eSet((EStructuralFeature)feature, attributeList);
    }

    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)descriptor).setAvailableValues((List)this.getAvailableValues(null));
        } else {
            Activator.log.warn(descriptor + "could not be completed.");
        }
    }

    public Object getValueToEdit(EObject objectToEdit) {
        if (!(objectToEdit instanceof Property)) {
            Activator.log.warn("the object to edit is not a Property");
            return "";
        }
        Property property = (Property)objectToEdit;
        Association association = property.getAssociation();
        if (association == null) {
            Activator.log.warn("the property is not a member end of an association");
            return "";
        }
        if (association.equals(property.getOwner())) {
            return Messages.AssociationEndOwnerModelHandler_ComboValue_Association;
        }
        return Messages.AssociationEndOwnerModelHandler_ComboValue_Class;
    }

    public boolean isChangeable(List<? extends EObject> objectsToEdit) {
        return true;
    }

    public String getId() {
        return ID;
    }

    public String getText() {
        return "AssociationEndOwnerHandler";
    }

    public Image getImage() {
        return Activator.getImage("/icons/ModelHandler.gif");
    }

    public AssociationEndOwnerHandlerState createState(boolean readOnly) {
        return new AssociationEndOwnerHandlerState(this, readOnly);
    }

    public List<String> getAvailableValues(EObject objects) {
        return this.availableValues;
    }

    public void handleNotifyChange(Notification notification, List<? extends EObject> objects, EMFPropertyEditorController adapter) {
        Object notificationFeature = notification.getFeature();
        if (!UMLPackage.eINSTANCE.getProperty_OwningAssociation().equals(notificationFeature)) {
            return;
        }
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                adapter.refreshDisplay();
            }
        }
    }

    public void addListenersToModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            eObject.eAdapters().add((Object)controller);
        }
    }

    public void removeListenersFromModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            eObject.eAdapters().remove((Object)controller);
        }
    }

    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        return null;
    }

    public boolean canCreateValueOperations(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getDeleteValueOperation(List<? extends EObject> objectsToEdit, Composite parent, List<Integer> indexes) {
        return null;
    }

    public boolean canCreateDeleteValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getEditValueOperation(List<? extends EObject> objectsToEdit, int index, Composite parent, Object value) {
        return null;
    }

    public boolean canCreateEditValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        return null;
    }

    public boolean canCreateMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        return false;
    }

    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        if (!(newValue instanceof String)) {
            Activator.log.warn("the new value for the association end owner handler was no a String");
            return null;
        }
        if (!(objectToEdit instanceof Property)) {
            Activator.log.warn("the object to edit is not a Property");
            return null;
        }
        Property property = (Property)objectToEdit;
        Association association = property.getAssociation();
        if (association == null) {
            Activator.log.warn("the property is not a member end of an association");
            return null;
        }
        String value = (String)newValue;
        Type owner = null;
        if (Messages.AssociationEndOwnerModelHandler_ComboValue_Class.equals(value)) {
            if (!(property.getOwner() instanceof Association)) {
                return null;
            }
            EList ownerList = association.getEndTypes();
            owner = ((Type)ownerList.get(0)).equals(property.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
            EReference feature = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
            if (owner instanceof Class) {
                ArrayList<Property> attributeList = new ArrayList<Property>();
                attributeList.addAll((Collection<Property>)((Class)owner).getAttributes());
                attributeList.add(property);
                return new SetRequest[]{new SetRequest(domain, (EObject)owner, (EStructuralFeature)feature, attributeList)};
            }
            Activator.log.error("The owner was not a class: " + owner, null);
            return null;
        }
        EReference feature = UMLPackage.eINSTANCE.getAssociation_OwnedEnd();
        ArrayList<Property> attributeList = new ArrayList<Property>();
        attributeList.addAll((Collection<Property>)association.getOwnedEnds());
        attributeList.add(property);
        return new SetRequest[]{new SetRequest(domain, (EObject)association, (EStructuralFeature)feature, attributeList)};
    }
}

