/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.uml.modelhandler;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.controller.EMFPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.uml.Activator;
import org.eclipse.papyrus.properties.runtime.uml.modelhandler.MultiplicityHandlerState;
import org.eclipse.papyrus.umlutils.MultiplicityElementUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplicityModelHandler
implements IEMFModelHandler {
    private final List<String> availableValues;
    public static final String ID = "Multiplicity";

    public MultiplicityModelHandler(List<String> availableValues) {
        this.availableValues = availableValues;
    }

    public void setValueInModel(EObject objectToEdit, Object newValue) {
        if (!(newValue instanceof String)) {
            Activator.log.warn("the new value for the multiplicity model handler was no a String");
            return;
        }
        String value = (String)newValue;
        try {
            int[] values = MultiplicityElementUtil.parseMultiplicity((String)value);
            if (values.length == 2) {
                int lower = values[0];
                int upper = values[1];
                EStructuralFeature lowerFeature = EMFUtils.getFeatureByName((EObject)objectToEdit, (String)"lower");
                EStructuralFeature upperFeature = EMFUtils.getFeatureByName((EObject)objectToEdit, (String)"upper");
                if (lowerFeature != null && upperFeature != null) {
                    objectToEdit.eSet(lowerFeature, (Object)lower);
                    objectToEdit.eSet(upperFeature, (Object)upper);
                }
            }
        }
        catch (NumberFormatException e) {
            Activator.log.error("Error during multiplicity parsing", (Throwable)e);
        }
    }

    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)descriptor).setAvailableValues((List)this.getAvailableValues(null));
        } else {
            Activator.log.warn(descriptor + "could not be completed.");
        }
    }

    public Object getValueToEdit(EObject objectToEdit) {
        if (objectToEdit instanceof MultiplicityElement) {
            return MultiplicityElementUtil.getMultiplicityAsStringWithoutSquareBrackets((MultiplicityElement)((MultiplicityElement)objectToEdit));
        }
        return "NaN";
    }

    public boolean isChangeable(List<? extends EObject> objectsToEdit) {
        return true;
    }

    public String getId() {
        return ID;
    }

    public String getText() {
        return "MultiplicityHandler";
    }

    public Image getImage() {
        return Activator.getImage("/icons/MultiplicityHandler.gif");
    }

    public MultiplicityHandlerState createState(boolean readOnly) {
        return new MultiplicityHandlerState(this, readOnly);
    }

    public List<String> getAvailableValues(EObject objects) {
        return this.availableValues;
    }

    public void handleNotifyChange(Notification notification, List<? extends EObject> objects, EMFPropertyEditorController adapter) {
        Object o;
        Object notificationFeature = notification.getFeature();
        if (!UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(notificationFeature) && !UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(notificationFeature)) {
            return;
        }
        switch (notification.getEventType()) {
            case 3: {
                ((EObject)notification.getNewValue()).eAdapters().add((Object)adapter);
                adapter.refreshDisplay();
                break;
            }
            case 5: {
                for (EObject newValue : (List)notification.getNewValue()) {
                    newValue.eAdapters().add((Object)adapter);
                }
                adapter.refreshDisplay();
                break;
            }
            case 4: {
                ((EObject)notification.getOldValue()).eAdapters().remove((Object)this);
                adapter.refreshDisplay();
                break;
            }
            case 6: {
                for (EObject newValue : (List)notification.getOldValue()) {
                    newValue.eAdapters().remove((Object)adapter);
                }
                adapter.refreshDisplay();
                break;
            }
            case 1: 
            case 2: {
                adapter.refreshDisplay();
            }
        }
        if (3 == notification.getEventType()) {
            o = notification.getFeature();
            if (o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue()) || o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue())) {
                ((EObject)notification.getNewValue()).eAdapters().add((Object)adapter);
                adapter.refreshDisplay();
            }
        } else if (5 == notification.getEventType()) {
            o = notification.getFeature();
            if (o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue()) || o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue())) {
                for (EObject newValue : (List)notification.getNewValue()) {
                    newValue.eAdapters().add((Object)adapter);
                }
                adapter.refreshDisplay();
            }
        } else if (4 == notification.getEventType()) {
            o = notification.getFeature();
            if (o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue()) || o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue())) {
                ((EObject)notification.getOldValue()).eAdapters().remove((Object)this);
                adapter.refreshDisplay();
            }
        } else if (6 == notification.getEventType() && ((o = notification.getFeature()).equals(UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue()) || o.equals(UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue()))) {
            for (EObject newValue : (List)notification.getOldValue()) {
                newValue.eAdapters().remove((Object)adapter);
            }
            adapter.refreshDisplay();
        }
    }

    public void addListenersToModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            eObject.eAdapters().add((Object)controller);
        }
    }

    public void removeListenersFromModel(List<? extends EObject> objectsToEdit, EMFPropertyEditorController controller) {
        for (EObject eObject : objectsToEdit) {
            eObject.eAdapters().remove((Object)controller);
        }
    }

    public List<IUndoableOperation> getCreateValueOperations(List<? extends EObject> objectsToEdit, Composite parent) {
        return null;
    }

    public boolean canCreateValueOperations(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getDeleteValueOperation(List<? extends EObject> objectsToEdit, Composite parent, List<Integer> indexes) {
        return null;
    }

    public boolean canCreateDeleteValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getEditValueOperation(List<? extends EObject> objectsToEdit, int index, Composite parent, Object value) {
        return null;
    }

    public boolean canCreateEditValueOperation(List<? extends EObject> objectsToEdit) {
        return false;
    }

    public IUndoableOperation getMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        return null;
    }

    public boolean canCreateMoveValueOperation(List<? extends EObject> objectsToEdit, List<Integer> indexes, Composite parent, int delta) {
        return false;
    }

    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        if (!(newValue instanceof String)) {
            Activator.log.warn("the new value for the multiplicity model handler was no a String");
            return null;
        }
        String value = (String)newValue;
        try {
            int[] values = MultiplicityElementUtil.parseMultiplicity((String)value);
            if (values.length == 2) {
                int lower = values[0];
                int upper = values[1];
                EStructuralFeature lowerFeature = EMFUtils.getFeatureByName((EObject)objectToEdit, (String)"lower");
                EStructuralFeature upperFeature = EMFUtils.getFeatureByName((EObject)objectToEdit, (String)"upper");
                if (lowerFeature != null && upperFeature != null) {
                    SetRequest req1 = new SetRequest(domain, objectToEdit, lowerFeature, (Object)lower);
                    SetRequest req2 = new SetRequest(domain, objectToEdit, upperFeature, (Object)upper);
                    return new SetRequest[]{req1, req2};
                }
            }
        }
        catch (NumberFormatException e) {
            Activator.log.error("Error during multiplicity parsing", (Throwable)e);
        }
        return null;
    }
}

