/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.uml.propertyeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MultiplicityPropertyEditor
extends AbstractPropertyEditor {
    public static final String ID = "org.eclipse.papyrus.properties.view.uml.multiplicityPropertyEditor";
    private Composite composite;
    protected List<String> values = new ArrayList<String>();
    private CCombo combo;

    public Composite createContent(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent, 0);
        int columnNu = this.getColumnNumber();
        GridLayout layout = new GridLayout(columnNu, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)data);
        if ((this.getDescriptor().getLabelPosition() & 0x4080) != 0) {
            this.createLabel(this.composite);
        }
        this.combo = this.getWidgetFactory().createCCombo(this.composite, 0x800800);
        this.combo.setItems(this.values.toArray(new String[0]));
        data = new GridData(4, 4, true, false);
        this.combo.setLayoutData((Object)data);
        this.getWidgetFactory().adapt((Composite)this.combo);
        this.combo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MultiplicityPropertyEditor.this.handleContentChanged();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiplicityPropertyEditor.this.handleContentChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.combo.setEnabled(!this.getIsReadOnly());
        if ((this.getDescriptor().getLabelPosition() & 0x20400) != 0) {
            this.createLabel(this.composite);
        }
        return this.composite;
    }

    protected int getColumnNumber() {
        if ((this.getDescriptor().getLabelPosition() & 0x480) != 0) {
            return 1;
        }
        return 2;
    }

    public void dispose() {
        if (this.isValid((Control)this.composite)) {
            this.composite.dispose();
            this.composite = null;
            this.setController(null);
        }
    }

    public boolean isDisposed() {
        if (this.composite == null) {
            return true;
        }
        return this.composite.isDisposed();
    }

    public Object getValue() {
        if (this.isValid((Control)this.combo)) {
            return this.combo.getText();
        }
        Activator.log.error("trying to read the value of the combo whereas the combo is disposed", null);
        return null;
    }

    public void handleContentChanged() {
        this.getController().updateModel();
    }

    public IStatus init(IPropertyEditorDescriptor descriptor) {
        this.setDescriptor(descriptor);
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            for (Object object : ((IBoundedValuesPropertyEditorDescriptor)descriptor).getAvailableValues()) {
                this.values.add(object.toString());
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.papyrus.properties.runtime", "Impossible to initialize the editor using descriptor :" + descriptor);
    }

    public void setValue(Object valueToEdit) {
        if (!this.isValid((Control)this.combo)) {
            return;
        }
        if (valueToEdit instanceof String) {
            this.combo.setText((String)valueToEdit);
        }
    }
}

