/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.IPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerProvider;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePropertyEditorControllerOperation
implements IOperation {
    private Composite parent;
    private List<Object> objectsToEdit;
    private final IPropertyEditorControllerDescriptor descriptor;
    private String controllerID;

    public CreatePropertyEditorControllerOperation(String id, List<Object> objectsToEdit, Composite parent, IPropertyEditorControllerDescriptor descriptor) {
        this.controllerID = id;
        this.descriptor = descriptor;
        this.objectsToEdit = objectsToEdit;
        this.parent = parent;
    }

    public String getControllerIdentifier() {
        return this.controllerID;
    }

    public IPropertyEditorController execute(IProvider provider) {
        if (provider instanceof PropertyEditorControllerProvider) {
            if (this.checkMultiSelection()) {
                IPropertyEditorController controller = ((PropertyEditorControllerProvider)provider).createPropertyEditorController(this.getControllerIdentifier());
                IStatus status = controller.initController(this.parent, this.objectsToEdit, this.descriptor);
                if (status.getSeverity() != 4) {
                    return controller;
                }
                Activator.log.error("(" + status.getSeverity() + ") Error during creation of Property Editor Controller: " + status.getMessage(), null);
                return null;
            }
            return null;
        }
        Activator.log.error("CreatePropertyEditorControllerOperation should execute on a PropertyEditorControllerProvider", null);
        return null;
    }

    protected boolean checkMultiSelection() {
        int selectionSize = this.objectsToEdit.size();
        if (selectionSize > 1) {
            return this.descriptor.acceptMultiSelection();
        }
        return true;
    }
}

