/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.core.utils.DisplayUtils;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.Messages;
import org.eclipse.papyrus.properties.runtime.controller.EMFTStructuralFeatureController;
import org.eclipse.papyrus.properties.runtime.controller.IBoundedValuesController;
import org.eclipse.papyrus.properties.runtime.controller.IWizardPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFTEReferenceController
extends EMFTStructuralFeatureController
implements IBoundedValuesController,
IWizardPropertyEditorController {
    public static final String ID = "emftEReferenceController";
    protected AdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected ILabelProvider labelProvider = this.initLabelProvider();

    @Override
    public Object getAvailableValues() {
        return this.getModelHandler().getAvailableValues(this.getObjectsToEdit().get(0));
    }

    protected ILabelProvider initLabelProvider() {
        ILabelProvider provider = DisplayUtils.getLabelProvider();
        if (provider != null) {
            return provider;
        }
        Activator.log.warn("Impossible to find the label provider from the service registry");
        return new AdapterFactoryLabelProvider(this.factory){

            public String getText(Object object) {
                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
                if (object instanceof EObject && ((EObject)object).eIsProxy()) {
                    return "Proxy - " + object;
                }
                return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
            }
        };
    }

    @Override
    public Object[] getCurrentValues() {
        EObject eObject = this.getObjectsToEdit().get(0);
        Object values = this.getModelHandler().getValueToEdit(eObject);
        if (values instanceof Object[]) {
            return (Object[])values;
        }
        if (values instanceof List) {
            return ((List)values).toArray();
        }
        if (values instanceof Object) {
            return Arrays.asList(values).toArray();
        }
        return new Object[]{values};
    }

    @Override
    public ILabelProvider getBrowserLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ILabelProvider getEditorLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public List<ViewerFilter> getViewerFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter typeFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
        filters.add(typeFilter);
        return filters;
    }

    public IStructuredContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider(this.factory){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ResourceSet) {
                    ResourceSet resourceSet = (ResourceSet)inputElement;
                    ArrayList contents = new ArrayList();
                    for (Resource resource : resourceSet.getResources()) {
                        contents.addAll(resource.getContents());
                    }
                    return contents.toArray();
                }
                return super.getElements(inputElement);
            }
        };
    }

    protected static boolean containsValidElements(Object element, Class<?> typeClass) {
        if (element instanceof Resource) {
            TreeIterator iter = ((Resource)element).getAllContents();
            while (iter.hasNext()) {
                if (!EMFTEReferenceController.containsValidElements(iter.next(), typeClass)) continue;
                return true;
            }
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            if (typeClass.isAssignableFrom(eObject.getClass())) {
                return true;
            }
            for (EObject content : eObject.eContents()) {
                if (!EMFTEReferenceController.containsValidElements(content, typeClass)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IUndoableOperation> getAvailableCreationOperations() {
        ArrayList<IUndoableOperation> undoableOperations = new ArrayList<IUndoableOperation>();
        EClass eClass = this.retrieveEClass();
        if (eClass == null || this.getObjectsToEdit() == null || this.getObjectsToEdit().size() == 0 || !(this.getModelHandler() instanceof EMFFeatureModelHandler)) {
            return undoableOperations;
        }
        EObject eObject = this.getObjectsToEdit().get(0);
        EStructuralFeature feature = ((EMFFeatureModelHandler)this.getModelHandler()).getFeatureByName(eObject);
        if (!(feature instanceof EReference)) {
            return undoableOperations;
        }
        try {
            List containedTypeServices = ElementEditServiceUtils.getEditServiceProvider().getContainedTypeEditServices(eObject, (EReference)feature);
            for (IElementEditService service : containedTypeServices) {
                CreateElementRequest request = new CreateElementRequest(this.getEditingDomain(), eObject, (IElementType)service.getAdapter(IElementType.class), (EReference)feature);
                request.setLabel(Messages.bind((String)Messages.EMFTEReferenceController_CreationOperationMenuLabel, (Object)service.getDisplayName()));
                ICommand command = service.getEditCommand((IEditCommandRequest)request);
                if (!command.canExecute()) continue;
                undoableOperations.add((IUndoableOperation)command);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return undoableOperations;
    }

    @Override
    protected EClass retrieveEClass() {
        List<? extends EObject> eObjects = this.getObjectsToEdit();
        if (eObjects == null) {
            return null;
        }
        if (eObjects.size() > 0) {
            return eObjects.get(0).eClass();
        }
        return null;
    }

    @Override
    public int openPostCreationDialog(Shell shell) {
        return 0;
    }

    @Override
    public IUndoableOperation getDeleteOperation(List<Object> objectsToDelete) {
        CompositeTransactionalCommand undoableOperation = new CompositeTransactionalCommand(this.getEditingDomain(), Messages.EMFTEReferenceController_DeleteElement_OperationLabel);
        EClass eClass = this.retrieveEClass();
        if (eClass == null || this.getObjectsToEdit() == null || this.getObjectsToEdit().size() == 0 || !(this.getModelHandler() instanceof EMFFeatureModelHandler)) {
            return undoableOperation;
        }
        for (Object objectToDelete : objectsToDelete) {
            if (objectToDelete instanceof EObject) {
                DestroyElementRequest request = new DestroyElementRequest(this.getEditingDomain(), (EObject)objectToDelete, false);
                ICommand operation = ElementEditServiceUtils.getCommandProvider((Object)objectToDelete).getEditCommand((IEditCommandRequest)request);
                if (operation == null || !operation.canExecute()) continue;
                undoableOperation.add((IUndoableOperation)operation);
                continue;
            }
            Activator.log.debug("the object to delete was not an EObject: " + objectToDelete);
        }
        return undoableOperation.reduce();
    }
}

