/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.core.utils.DisplayUtils;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.EMFTStructuralFeatureController;
import org.eclipse.papyrus.properties.runtime.controller.ILabelProviderController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFFeatureModelHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFTLabelProviderStructuralFeatureController
extends EMFTStructuralFeatureController
implements ILabelProviderController {
    public static final String ID = "emftLabelProviderStructuralFeatureController";
    protected ILabelProvider labelProvider = this.initLabelProvider();

    protected ILabelProvider initLabelProvider() {
        ILabelProvider provider = DisplayUtils.getLabelProvider();
        if (provider != null) {
            return provider;
        }
        Activator.log.warn("Impossible to find the label provider from the service registry");
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        return new AdapterFactoryLabelProvider((AdapterFactory)factory){

            public String getText(Object object) {
                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
                if (object instanceof EObject && ((EObject)object).eIsProxy()) {
                    return "Proxy - " + object;
                }
                return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
            }
        };
    }

    @Override
    public ILabelProvider getEditorLabelProvider() {
        return this.labelProvider;
    }

    public List<IUndoableOperation> getAvailableCreationOperations() {
        EClass eClass = this.retrieveEClass();
        if (eClass == null || this.getObjectsToEdit() == null || this.getObjectsToEdit().size() == 0 || !(this.getModelHandler() instanceof EMFFeatureModelHandler)) {
            return new ArrayList<IUndoableOperation>();
        }
        EObject eObject = this.getObjectsToEdit().get(0);
        EStructuralFeature feature = ((EMFFeatureModelHandler)this.getModelHandler()).getFeatureByName(eObject);
        if (!(feature instanceof EReference)) {
            return new ArrayList<IUndoableOperation>();
        }
        IElementType type = ElementTypeRegistry.getInstance().getElementType(eClass);
        IEditHelper helper = type.getEditHelper();
        List values = helper.getContainedValues(eObject, (EReference)feature);
        if (values != null) {
            for (Object nextValue : values) {
                if (!(nextValue instanceof IElementType)) continue;
                IElementType next = (IElementType)nextValue;
                System.err.println(next);
            }
        }
        ArrayList<IUndoableOperation> operations = new ArrayList<IUndoableOperation>();
        Collection list = this.getEditingDomain().getNewChildDescriptors((Object)this.getObjectsToEdit().get(0), null);
        System.err.println(list);
        return operations;
    }

    @Override
    protected EClass retrieveEClass() {
        List<? extends EObject> eObjects = this.getObjectsToEdit();
        if (eObjects == null) {
            return null;
        }
        if (eObjects.size() > 0) {
            return eObjects.get(0).eClass();
        }
        return null;
    }
}

