/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.properties.runtime.controller.EMFPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.TransactionUtil;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;

public abstract class EMFTPropertyEditorController
extends EMFPropertyEditorController {
    private TransactionalEditingDomain editingDomain;
    protected IEMFModelHandler modelHandler;

    public void updateModel() {
        EMFTControllerCommand command;
        CompositeCommand cc = new CompositeCommand("Set Value Command");
        Object valueToSet = this.getEditorValue();
        for (Object obj : this.objectToEdit) {
            EObject elementToEdit = (EObject)obj;
            SetRequest[] req = null;
            req = this.modelHandler.getSetRequest(this.getEditingDomain(), elementToEdit, valueToSet);
            if (req == null) break;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)elementToEdit);
            if (provider != null) {
                ICommand editCommand = null;
                SetRequest[] setRequestArray = req;
                int n = req.length;
                int n2 = 0;
                while (n2 < n) {
                    SetRequest current = setRequestArray[n2];
                    editCommand = provider.getEditCommand((IEditCommandRequest)current);
                    if (editCommand != null && editCommand.canExecute()) {
                        cc.add((IUndoableOperation)editCommand);
                    }
                    ++n2;
                }
            }
            if (!cc.canExecute() || TransactionUtil.isReadTransactionInProgress(this.getEditingDomain(), true, true)) continue;
            this.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cc));
            return;
        }
        if ((command = new EMFTControllerCommand()).canExecute() && !TransactionUtil.isReadTransactionInProgress(this.editingDomain, true, true)) {
            this.editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
        }
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    static /* synthetic */ TransactionalEditingDomain access$0(EMFTPropertyEditorController eMFTPropertyEditorController) {
        return eMFTPropertyEditorController.editingDomain;
    }

    protected class EMFTControllerCommand
    extends AbstractTransactionalCommand {
        public EMFTControllerCommand() {
            super(EMFTPropertyEditorController.this.editingDomain, "Editing Property", EMFTControllerCommand.getWorkspaceFiles(EMFTPropertyEditorController.this.getObjectsToEdit()));
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EMFTPropertyEditorController.this.setValueInModel(EMFTPropertyEditorController.this.getEditorValue());
            return CommandResult.newOKCommandResult(EMFTPropertyEditorController.this.getObjectsToEdit());
        }
    }
}

