/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.properties.runtime.controller.EMFTPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.EMFTPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EMFUtils;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFTStructuralFeatureController
extends EMFTPropertyEditorController {
    private EMFTPropertyEditorControllerDescriptor descriptor;
    public static final String ID = "emftStructuralFeatureController";

    @Override
    public IStatus initController(Composite parent, List<Object> objectsToEdit, IPropertyEditorControllerDescriptor descriptor) {
        IPropertyEditorControllerDescriptor predefinedDescriptor;
        this.setParent(parent);
        IPropertyEditorControllerDescriptor realDescriptor = descriptor;
        if (descriptor instanceof PredefinedControllerDescriptor && (predefinedDescriptor = ((PredefinedControllerDescriptor)descriptor).getDescriptor()) instanceof EMFTPropertyEditorControllerDescriptor) {
            realDescriptor = predefinedDescriptor;
        }
        if (!(realDescriptor instanceof EMFTPropertyEditorControllerDescriptor)) {
            return new Status(4, "org.eclipse.papyrus.properties.runtime", "impossible to adapt descriptor to an EMFTPropertyEditorControllerDescriptor");
        }
        this.descriptor = (EMFTPropertyEditorControllerDescriptor)realDescriptor;
        this.modelHandler = this.descriptor.getHandler();
        this.setObjectsToEdit(objectsToEdit);
        TransactionalEditingDomain editingDomain = EMFUtils.getTransactionalEditingDomain(objectsToEdit);
        if (editingDomain == null && !objectsToEdit.isEmpty()) {
            return new Status(4, "org.eclipse.papyrus.properties.runtime", "impossible to find an editing domain for the controller.");
        }
        this.setEditingDomain(editingDomain);
        return Status.OK_STATUS;
    }

    @Override
    public boolean acceptMultiSelection() {
        return this.descriptor.acceptMultiSelection();
    }

    public IEMFModelHandler getModelHandler() {
        return this.modelHandler;
    }

    public EMFTPropertyEditorControllerDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected void addListenersToModel() {
        this.modelHandler.addListenersToModel(this.getObjectsToEdit(), this);
    }

    @Override
    protected String getDefaultLabel() {
        return this.descriptor.getFeatureNameToEdit();
    }

    @Override
    protected Object getValueToEdit() {
        if (!this.getObjectsToEdit().isEmpty()) {
            EObject object = this.getObjectsToEdit().get(0);
            return this.getModelHandler().getValueToEdit(object);
        }
        return new Object();
    }

    @Override
    protected void setValueInModel(Object value) {
        for (EObject eObject : this.getObjectsToEdit()) {
            this.getModelHandler().setValueInModel(eObject, value);
        }
    }

    @Override
    protected IStatus initPropertyEditor(IPropertyEditorDescriptor descriptor) {
        this.getPropertyEditor().setIsReadOnly(!this.getModelHandler().isChangeable(this.getObjectsToEdit()));
        this.getModelHandler().completeEditorDescriptor(descriptor, this.getObjectsToEdit());
        return this.getPropertyEditor().init(descriptor);
    }

    @Override
    protected void removeListenersFromModel() {
        this.getModelHandler().removeListenersFromModel(this.getObjectsToEdit(), this);
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        for (EObject eObject : this.getObjectsToEdit()) {
            if (!eObject.getClass().equals(type)) continue;
            return true;
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
        this.getModelHandler().handleNotifyChange(notification, this.getObjectsToEdit(), this);
    }

    public void setTarget(Notifier newTarget) {
    }

    @Override
    public IUndoableOperation getMoveCurrentValuesOperation(List<Integer> indexes, int delta) {
        return this.getModelHandler().getMoveValueOperation(this.getObjectsToEdit(), indexes, this.getComposite(), delta);
    }

    @Override
    public boolean canMoveValues(List<Integer> indexes, int delta) {
        return this.getModelHandler().canCreateMoveValueOperation(this.getObjectsToEdit(), indexes, this.getComposite(), delta);
    }

    protected EClass retrieveEClass() {
        List<? extends EObject> eObjects = this.getObjectsToEdit();
        if (eObjects == null) {
            return null;
        }
        if (eObjects.size() > 0) {
            return eObjects.get(0).eClass();
        }
        return null;
    }

    @Override
    public List<IUndoableOperation> getCreateValueOperations() {
        return this.getModelHandler().getCreateValueOperations(this.getObjectsToEdit(), this.getComposite());
    }

    @Override
    public boolean canCreateValueOperations() {
        return this.getModelHandler().canCreateValueOperations(this.getObjectsToEdit());
    }

    @Override
    public IUndoableOperation getDeleteValueOperation(List<Integer> indexes) {
        return this.getModelHandler().getDeleteValueOperation(this.getObjectsToEdit(), this.getComposite(), indexes);
    }

    @Override
    public boolean canDeleteValueOperation() {
        return this.getModelHandler().canCreateDeleteValueOperation(this.getObjectsToEdit());
    }

    @Override
    public IUndoableOperation getEditValueOperation(int index, Composite parent, Object value) {
        return this.getModelHandler().getEditValueOperation(this.getObjectsToEdit(), index, parent, value);
    }

    @Override
    public boolean canCreateEditOperation(int index, Composite parent, Object value) {
        return true;
    }
}

