/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.IPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.AbstractPropertyEditor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.PropertyEditorService;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEditorController
implements IDisposable,
IPropertyEditorController {
    protected List<? extends Object> objectToEdit;
    protected Composite composite;
    protected AbstractPropertyEditor propertyEditor;

    @Override
    public void setObjectsToEdit(List<? extends Object> objectToEdit) {
        assert (objectToEdit != null && !objectToEdit.isEmpty()) : "List of object to edit should be neither null nor empty";
        this.objectToEdit = objectToEdit;
        this.addListenersToModel();
    }

    @Override
    public void changeObjectsToEdit(List<? extends Object> objectToEdit) {
        this.removeListenersFromModel();
        this.setObjectsToEdit(objectToEdit);
    }

    @Override
    public void setParent(Composite composite) {
        this.composite = composite;
    }

    @Override
    public boolean acceptMultiSelection() {
        return true;
    }

    public AbstractPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    protected void setPropertyEditor(AbstractPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public List<? extends Object> getObjectsToEdit() {
        return this.objectToEdit;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    @Override
    public void createPropertyEditor(IPropertyEditorDescriptor descriptor, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.setPropertyEditor(PropertyEditorService.getInstance().createPropertyEditor(this, descriptor.getEditorId(), widgetFactory));
        IStatus status = this.initPropertyEditor(descriptor);
        if (4 != status.getSeverity()) {
            this.getPropertyEditor().createContent(this.getComposite());
        } else {
            Activator.log.error("Could not create the property editor because of initialisation issues.", null);
        }
        this.refreshDisplay();
    }

    protected abstract String getDefaultLabel();

    protected abstract IStatus initPropertyEditor(IPropertyEditorDescriptor var1);

    @Override
    public abstract IStatus initController(Composite var1, List<Object> var2, IPropertyEditorControllerDescriptor var3);

    protected abstract void setValueInModel(Object var1);

    protected Object getEditorValue() {
        if (this.isValid(this.getPropertyEditor())) {
            return this.getPropertyEditor().getValue();
        }
        return null;
    }

    protected boolean isValid(AbstractPropertyEditor propertyEditor) {
        return this.getPropertyEditor() != null && !this.getPropertyEditor().isDisposed();
    }

    @Override
    public void refreshDisplay() {
        if (this.isValid(this.getPropertyEditor())) {
            this.getPropertyEditor().setValue(this.getValueToEdit());
        }
    }

    protected abstract Object getValueToEdit();

    protected abstract void addListenersToModel();

    protected abstract void removeListenersFromModel();

    public abstract void updateModel();

    public void dispose() {
        this.removeListenersFromModel();
        if (this.getPropertyEditor() != null) {
            this.getPropertyEditor().dispose();
        }
        this.setPropertyEditor(null);
    }
}

