/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptorFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

public class PropertyEditorControllerConfiguration {
    protected String description;
    protected ImageDescriptor descriptor;
    protected String id;
    protected IConfigurationElement element;
    private IPropertyEditorControllerDescriptorFactory factory;

    protected void setElement(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImageDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ImageDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static PropertyEditorControllerConfiguration parse(IConfigurationElement element) throws CoreException {
        PropertyEditorControllerConfiguration configuration = new PropertyEditorControllerConfiguration();
        configuration.setId(element.getAttribute("id"));
        configuration.setDescription(element.getAttribute("description"));
        configuration.setElement(element);
        configuration.setDescriptorFactory((IPropertyEditorControllerDescriptorFactory)element.createExecutableExtension("factory"));
        assert (configuration.getId() != null) : "impossible to get the identifier for the provider " + element.getName();
        return configuration;
    }

    public void setDescriptorFactory(IPropertyEditorControllerDescriptorFactory factory) {
        assert (factory != null) : "factory should not be null for configuration " + this.getId();
        this.factory = factory;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public PropertyEditorController instanciateController() throws CoreException {
        return (PropertyEditorController)this.getElement().createExecutableExtension("class");
    }

    public IPropertyEditorControllerDescriptor createControllerDescriptor(Node controllerNode, Bundle bundle) {
        return this.factory.createDescriptor(controllerNode, bundle);
    }
}

