/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.CreatePropertyEditorControllerDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.controller.CreatePropertyEditorControllerOperation;
import org.eclipse.papyrus.properties.runtime.controller.IPropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerConfiguration;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

public class PropertyEditorControllerProvider
extends AbstractProvider {
    private Map<String, PropertyEditorControllerConfiguration> controllers = new HashMap<String, PropertyEditorControllerConfiguration>();
    private Bundle bundle;

    public IPropertyEditorController createPropertyEditorController(String controllerIdentifier) {
        PropertyEditorControllerConfiguration configuration;
        block3: {
            try {
                configuration = this.controllers.get(controllerIdentifier);
                if (configuration != null) break block3;
                Activator.log.error("impossible to find the configuration for controller " + controllerIdentifier, null);
                return null;
            }
            catch (CoreException e) {
                e.printStackTrace();
                Activator.log.error((Throwable)e);
                return null;
            }
        }
        PropertyEditorController controller = configuration.instanciateController();
        return controller;
    }

    public void configure(IConfigurationElement providerConfiguration) {
        try {
            this.bundle = Platform.getBundle((String)providerConfiguration.getContributor().getName());
            IConfigurationElement[] iConfigurationElementArray = providerConfiguration.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("PropertyEditorController".equals(element.getName())) {
                    PropertyEditorControllerConfiguration configuration = PropertyEditorControllerConfiguration.parse(element);
                    this.controllers.put(configuration.getId(), configuration);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            Activator.log.error((Throwable)e);
        }
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreatePropertyEditorControllerOperation) {
            CreatePropertyEditorControllerOperation createPropertyEditorOperation = (CreatePropertyEditorControllerOperation)operation;
            String operationIdentifier = createPropertyEditorOperation.getControllerIdentifier();
            return this.controllers.containsKey(operationIdentifier);
        }
        if (operation instanceof CreatePropertyEditorControllerDescriptorOperation) {
            CreatePropertyEditorControllerDescriptorOperation controllerDescriptorOperation = (CreatePropertyEditorControllerDescriptorOperation)operation;
            return this.controllers.containsKey(controllerDescriptorOperation.getControllerID());
        }
        return false;
    }

    public IPropertyEditorControllerDescriptor generateDescriptor(String controllerID, Node contentNode) {
        PropertyEditorControllerConfiguration configuration = this.controllers.get(controllerID);
        return configuration.createControllerDescriptor(contentNode, this.bundle);
    }
}

