/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.CreatePropertyEditorControllerDescriptorOperation;
import org.eclipse.papyrus.properties.runtime.controller.CreatePropertyEditorControllerOperation;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerProvider;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.predefined.CreatePredefinedPropertyControllerProviderOperation;
import org.eclipse.papyrus.properties.runtime.controller.predefined.GetAllPredefinedPropertyEditorControllersOperation;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedPropertyControllerProvider;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorControllerService
extends Service {
    protected static PropertyEditorControllerService instance;

    protected PropertyEditorControllerService() {
    }

    public static synchronized PropertyEditorControllerService getInstance() {
        if (instance == null) {
            instance = new PropertyEditorControllerService();
            instance.configureProviders("org.eclipse.papyrus.properties.runtime", "propertyEditorControllerProvider");
        }
        return instance;
    }

    public IPropertyEditorControllerDescriptor createPropertyEditorControllerDescriptor(String controllerId, Node controllerNode, Bundle bundle) {
        return (IPropertyEditorControllerDescriptor)this.executeUnique(ExecutionStrategy.REVERSE, new CreatePropertyEditorControllerDescriptorOperation(controllerId, controllerNode, bundle));
    }

    public IPropertyEditorControllerDescriptor createPredefinedControllerDescriptor(String predefinedID) {
        return (IPropertyEditorControllerDescriptor)this.executeUnique(ExecutionStrategy.REVERSE, new CreatePredefinedPropertyControllerProviderOperation(predefinedID));
    }

    public Map<String, PredefinedControllerDescriptor> getAllPredefinedControllers() {
        List predefinedControllers = this.execute(ExecutionStrategy.REVERSE, new GetAllPredefinedPropertyEditorControllersOperation());
        HashMap<String, PredefinedControllerDescriptor> flattenMap = new HashMap<String, PredefinedControllerDescriptor>();
        for (Map subList : predefinedControllers) {
            flattenMap.putAll(subList);
        }
        return flattenMap;
    }

    public PropertyEditorController createPropertyEditorController(List<Object> objectsToEdit, Composite parent, IPropertyEditorControllerDescriptor descriptor) {
        Object result = this.executeUnique(ExecutionStrategy.REVERSE, new CreatePropertyEditorControllerOperation(descriptor.getControllerID(), objectsToEdit, parent, descriptor));
        return (PropertyEditorController)result;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (operation instanceof CreatePropertyEditorControllerOperation) {
                return this.getProvider().provides(operation);
            }
            if (operation instanceof CreatePredefinedPropertyControllerProviderOperation) {
                return this.getProvider().provides(operation);
            }
            if (operation instanceof CreatePropertyEditorControllerDescriptorOperation) {
                return this.getProvider().provides(operation);
            }
            if (operation instanceof GetAllPredefinedPropertyEditorControllersOperation) {
                return this.getProvider().provides(operation);
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof PropertyEditorControllerProvider) {
                    PropertyEditorControllerProvider defaultProvider = (PropertyEditorControllerProvider)newProvider;
                    defaultProvider.configure(this.getElement());
                } else if (this.provider instanceof PredefinedPropertyControllerProvider) {
                    PredefinedPropertyControllerProvider defaultProvider = (PredefinedPropertyControllerProvider)newProvider;
                    defaultProvider.configure(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

