/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.descriptor;

import java.util.List;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.BeanPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptorFactory;
import org.eclipse.papyrus.properties.runtime.propertyeditor.PropertyEditorService;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintParser;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanPropertyEditorControllerDescriptorFactory
implements IPropertyEditorControllerDescriptorFactory {
    public IPropertyEditorControllerDescriptor createDescriptor(Node controllerNode, Bundle bundle) {
        String controllerID = "";
        boolean multiSelection = true;
        NamedNodeMap attributes = controllerNode.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if ("id".equals(attribute.getNodeName())) {
                controllerID = attribute.getNodeValue();
            }
            ++i;
        }
        String propertyName = null;
        Object modelHandler = null;
        IPropertyEditorDescriptor editorDescriptor = null;
        List<IConstraintDescriptor> constraints = null;
        NodeList children = controllerNode.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if ("property".equals(child.getNodeName())) {
                Node featureNameNode;
                NamedNodeMap featureAttributes = child.getAttributes();
                if (featureAttributes != null && (featureNameNode = featureAttributes.getNamedItem("name")) != null) {
                    propertyName = featureNameNode.getNodeValue();
                }
            } else if ("editor".equals(child.getNodeName())) {
                if (child.hasAttributes()) {
                    Node editorIDNode = child.getAttributes().getNamedItem("id");
                    editorDescriptor = PropertyEditorService.getInstance().createPropertyEditorDescriptor(editorIDNode.getNodeValue(), child);
                }
            } else if ("constraints".equals(child.getNodeName())) {
                constraints = ConstraintParser.parseConstraints(child, bundle);
            }
            ++i2;
        }
        assert (modelHandler != null) : "impossible to find handler for controller " + controllerID;
        assert (propertyName != null && !"".equals(propertyName)) : "impossible to find feature name for controller " + controllerID;
        assert (editorDescriptor != null) : "impossible to create editor descriptor";
        assert (constraints != null) : "Impossible to parse constraints";
        return new BeanPropertyEditorControllerDescriptor(controllerID, multiSelection, propertyName, editorDescriptor, constraints);
    }
}

