/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.descriptor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.state.AbstractState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerDescriptorState
extends AbstractState {
    private static final String CONTROLLER_DESCRIPTOR_EDITOR_DLG = "ControllerDescriptorEditorDialog";
    protected IPropertyEditorControllerDescriptor descriptor;
    protected String id;
    private PropertyChangeSupport changeSupport;

    public ControllerDescriptorState(IPropertyEditorControllerDescriptor descriptor, boolean readOnly) {
        super(readOnly);
        this.descriptor = descriptor;
        this.id = descriptor.getControllerID();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public IPropertyEditorControllerDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getEditionDialogId() {
        return CONTROLLER_DESCRIPTOR_EDITOR_DLG;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        this.changeSupport.firePropertyChange("id", oldId, id);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public List<? extends ITraversableModelElement> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Node generateNode(Document document) {
        Activator.log.error("not implemented", null);
        return null;
    }

    public void createPreview(Composite composite) {
        Activator.log.error("not implements...", null);
    }
}

