/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.EMFTPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IBindingLabelProviderDescriptor;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFTBindingPropertyEditorControllerDescriptor
extends EMFTPropertyEditorControllerDescriptor
implements IBindingLabelProviderDescriptor {
    private String message;
    private String[] featuresName;

    public EMFTBindingPropertyEditorControllerDescriptor(String controllerID, boolean multiSelection, String featureNameToEdit, IEMFModelHandler handler, IPropertyEditorDescriptor editorDescriptor, List<IConstraintDescriptor> constraints, String message, String[] featuresName) {
        super(controllerID, multiSelection, featureNameToEdit, handler, editorDescriptor, constraints);
        this.message = message;
        this.featuresName = featuresName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String[] getFeaturesNameToBind() {
        return this.featuresName;
    }

    @Override
    public String computeBindings(Object objectToEdit) {
        ArrayList<Object> bindings = new ArrayList<Object>();
        if (objectToEdit instanceof EObject) {
            String[] stringArray = this.getFeaturesNameToBind();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                EStructuralFeature feature = this.getFeatureByName((EObject)objectToEdit, name);
                if (feature != null) {
                    Object value = ((EObject)objectToEdit).eGet(feature);
                    bindings.add(value);
                } else {
                    Activator.log.error("impossible to find the feature with name : " + name, null);
                }
                ++n2;
            }
        }
        return NLS.bind((String)this.getMessage(), (Object[])bindings.toArray(new String[0]));
    }

    protected EStructuralFeature getFeatureByName(EObject objectToEdit, String name) {
        EStructuralFeature feature = objectToEdit.eClass().getEStructuralFeature(name);
        if (feature != null) {
            return feature;
        }
        return null;
    }
}

