/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.EMFTBindingPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.EMFTPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.EMFTPropertyEditorControllerDescriptorFactory;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.PropertyEditorService;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintParser;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EMFTBindingPropertyEditorControllerDescriptorFactory
extends EMFTPropertyEditorControllerDescriptorFactory {
    private String message;
    private List<String> featuresName = new ArrayList<String>();

    public EMFTPropertyEditorControllerDescriptor createDescriptor(Node controllerNode, Bundle bundle) {
        String controllerID = "";
        boolean multiSelection = true;
        NamedNodeMap attributes = controllerNode.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if ("id".equals(attribute.getNodeName())) {
                controllerID = attribute.getNodeValue();
            }
            ++i;
        }
        IEMFModelHandler modelHandler = null;
        String featureName = null;
        IPropertyEditorDescriptor editorDescriptor = null;
        List<IConstraintDescriptor> constraints = null;
        NodeList children = controllerNode.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if ("feature".equals(child.getNodeName())) {
                NamedNodeMap featureAttributes = child.getAttributes();
                if (featureAttributes != null) {
                    Node featureNameNode = featureAttributes.getNamedItem("name");
                    if (featureNameNode != null) {
                        featureName = featureNameNode.getNodeValue();
                    }
                    modelHandler = this.parseModelHandler(child);
                }
            } else if ("editor".equals(child.getNodeName())) {
                if (child.hasAttributes()) {
                    Node editorIDNode = child.getAttributes().getNamedItem("id");
                    editorDescriptor = PropertyEditorService.getInstance().createPropertyEditorDescriptor(editorIDNode.getNodeValue(), child);
                }
            } else if ("binding".equals(child.getNodeName())) {
                if (child.hasAttributes()) {
                    Node messageNode = child.getAttributes().getNamedItem("message");
                    this.message = messageNode.getNodeValue();
                }
                NodeList features = child.getChildNodes();
                int j = 0;
                while (j < features.getLength()) {
                    Node featureNode = features.item(j);
                    if ("feature".equals(featureNode.getNodeName()) && featureNode.hasAttributes()) {
                        this.featuresName.add(featureNode.getAttributes().getNamedItem("name").getNodeValue());
                    }
                    ++j;
                }
            } else if ("constraints".equals(child.getNodeName())) {
                constraints = ConstraintParser.parseConstraints(child, bundle);
            }
            ++i2;
        }
        assert (modelHandler != null) : "impossible to find handler for controller " + controllerID;
        assert (featureName != null && !"".equals(featureName)) : "impossible to find feature name for controller " + controllerID;
        assert (editorDescriptor != null) : "impossible to create editor descriptor";
        assert (constraints != null) : "Impossible to parse constraints";
        return new EMFTBindingPropertyEditorControllerDescriptor(controllerID, multiSelection, featureName, modelHandler, editorDescriptor, constraints, this.message, this.featuresName.toArray(new String[0]));
    }
}

