/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.descriptor;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerService;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandlerState;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.state.IState;
import org.eclipse.papyrus.properties.runtime.state.ITraversableModelElement;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFTPropertyEditorControllerDescriptor
implements IPropertyEditorControllerDescriptor {
    protected final IEMFModelHandler handler;
    protected final boolean multiSelection;
    protected final String controllerID;
    protected final String featureNameToEdit;
    protected final IPropertyEditorDescriptor editorDescriptor;
    private final List<IConstraintDescriptor> constraints;

    @Override
    public boolean acceptMultiSelection() {
        return this.multiSelection;
    }

    public String getFeatureNameToEdit() {
        return this.featureNameToEdit;
    }

    public IEMFModelHandler getHandler() {
        return this.handler;
    }

    public EMFTPropertyEditorControllerDescriptor(String controllerID, boolean multiSelection, String featureNameToEdit, IEMFModelHandler handler, IPropertyEditorDescriptor editorDescriptor, List<IConstraintDescriptor> constraints) {
        this.controllerID = controllerID;
        this.multiSelection = multiSelection;
        this.featureNameToEdit = featureNameToEdit;
        this.handler = handler;
        this.editorDescriptor = editorDescriptor;
        this.constraints = constraints;
    }

    @Override
    public String getControllerID() {
        return this.controllerID;
    }

    @Override
    public IPropertyEditorDescriptor getEditorDescriptor() {
        return this.editorDescriptor;
    }

    @Override
    public List<IConstraintDescriptor> getConstraintDescriptors() {
        return this.constraints;
    }

    @Override
    public Image getImage() {
        return Activator.getImage("/icons/EMFTController.gif");
    }

    @Override
    public String getText() {
        return "Property editor for: " + this.getFeatureNameToEdit();
    }

    @Override
    public ControllerDescriptorState createState(boolean readOnly) {
        return new EMFTPropertyEditorControllerDescriptorState(this, readOnly);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EMFTPropertyEditorControllerDescriptorState
    extends ControllerDescriptorState {
        private PropertyChangeSupport changeSupport;
        private String featureNameState;
        private IEMFModelHandlerState modelHandlerState;
        private boolean multiSelectionState;
        private IState editorState;

        public EMFTPropertyEditorControllerDescriptorState(EMFTPropertyEditorControllerDescriptor descriptor, boolean readOnly) {
            super(descriptor, readOnly);
            this.featureNameState = descriptor.getFeatureNameToEdit();
            this.multiSelectionState = descriptor.acceptMultiSelection();
            this.modelHandlerState = descriptor.getHandler().createState(true);
            this.editorState = descriptor.getEditorDescriptor().createState(readOnly);
            this.changeSupport = new PropertyChangeSupport(this);
        }

        @Override
        public EMFTPropertyEditorControllerDescriptor getDescriptor() {
            return (EMFTPropertyEditorControllerDescriptor)super.getDescriptor();
        }

        public PropertyChangeSupport getChangeSupport() {
            return this.changeSupport;
        }

        public void setChangeSupport(PropertyChangeSupport changeSupport) {
            this.changeSupport = changeSupport;
        }

        public String getFeatureNameState() {
            return this.featureNameState;
        }

        public void setFeatureNameState(String featureNameState) {
            String oldName = this.featureNameState;
            this.featureNameState = featureNameState;
            this.changeSupport.firePropertyChange("featureNameState", oldName, this.featureNameState);
        }

        public IEMFModelHandlerState getModelHandlerState() {
            return this.modelHandlerState;
        }

        public void setModelHandler(IEMFModelHandlerState modelHandlerState) {
            IEMFModelHandlerState oldHandlerState = this.modelHandlerState;
            this.modelHandlerState = modelHandlerState;
            this.changeSupport.firePropertyChange("modelHandler", oldHandlerState, this.modelHandlerState);
        }

        public boolean isMultiSelection() {
            return EMFTPropertyEditorControllerDescriptor.this.multiSelection;
        }

        public void setMultiSelection(boolean multiSelectionState) {
            boolean oldSelection = this.multiSelectionState;
            this.multiSelectionState = multiSelectionState;
            this.changeSupport.firePropertyChange("multiSelection", oldSelection, this.multiSelectionState);
        }

        @Override
        public List<? extends ITraversableModelElement> getChildren() {
            ArrayList<IEMFModelHandlerState> children = new ArrayList<IEMFModelHandlerState>(1);
            children.add(this.modelHandlerState);
            return children;
        }

        @Override
        public Node generateNode(Document document) {
            Element node = document.createElement("controller");
            node.setAttribute("id", this.getId());
            node.appendChild(this.modelHandlerState.generateNode(document));
            this.generateEditorNode(node, document);
            return node;
        }

        protected void generateEditorNode(Element node, Document document) {
            Node editorNode = this.editorState.generateNode(document);
            node.appendChild(editorNode);
        }

        @Override
        public void createPreview(Composite composite) {
            PropertyEditorController controller = PropertyEditorControllerService.getInstance().createPropertyEditorController(Collections.<Object>emptyList(), composite, this.descriptor);
            if (controller != null) {
                controller.createPropertyEditor(this.getDescriptor().getEditorDescriptor(), new TabbedPropertySheetWidgetFactory());
            }
        }
    }
}

