/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.descriptor;

import java.util.List;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.EMFTPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptorFactory;
import org.eclipse.papyrus.properties.runtime.modelhandler.ModelHandlerService;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.IEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.PropertyEditorService;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.view.constraints.ConstraintParser;
import org.eclipse.papyrus.properties.runtime.view.constraints.IConstraintDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EMFTPropertyEditorControllerDescriptorFactory
implements IPropertyEditorControllerDescriptorFactory {
    public EMFTPropertyEditorControllerDescriptor createDescriptor(Node controllerNode, Bundle bundle) {
        String controllerID = "";
        boolean multiSelection = true;
        NamedNodeMap attributes = controllerNode.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if ("id".equals(attribute.getNodeName())) {
                controllerID = attribute.getNodeValue();
            }
            ++i;
        }
        String featureName = null;
        IEMFModelHandler modelHandler = null;
        IPropertyEditorDescriptor editorDescriptor = null;
        List<IConstraintDescriptor> constraints = null;
        NodeList children = controllerNode.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if ("feature".equals(child.getNodeName())) {
                NamedNodeMap featureAttributes = child.getAttributes();
                if (featureAttributes != null) {
                    Node featureNameNode = featureAttributes.getNamedItem("name");
                    if (featureNameNode != null) {
                        featureName = featureNameNode.getNodeValue();
                    }
                    modelHandler = this.parseModelHandler(child);
                }
            } else if ("editor".equals(child.getNodeName())) {
                if (child.hasAttributes()) {
                    Node editorIDNode = child.getAttributes().getNamedItem("id");
                    editorDescriptor = PropertyEditorService.getInstance().createPropertyEditorDescriptor(editorIDNode.getNodeValue(), child);
                    if (editorDescriptor == null) {
                        Activator.log.error("impossible to create editor descriptor", null);
                    }
                }
            } else if ("constraints".equals(child.getNodeName())) {
                constraints = ConstraintParser.parseConstraints(child, bundle);
            }
            ++i2;
        }
        assert (modelHandler != null) : "impossible to find handler for controller " + controllerID;
        assert (featureName != null && !"".equals(featureName)) : "impossible to find feature name for controller " + controllerID;
        assert (constraints != null) : "Impossible to parse constraints";
        return new EMFTPropertyEditorControllerDescriptor(controllerID, multiSelection, featureName, modelHandler, editorDescriptor, constraints);
    }

    protected IEMFModelHandler parseModelHandler(Node node) {
        Node handlerIDNameNode;
        String handlerID = null;
        NamedNodeMap featureAttributes = node.getAttributes();
        if (featureAttributes != null && (handlerIDNameNode = featureAttributes.getNamedItem("handlerID")) != null) {
            handlerID = handlerIDNameNode.getNodeValue();
        }
        if (handlerID == null) {
            Activator.log.error("impossible to find model handler for node " + node, null);
            return null;
        }
        Object modelHandler = ModelHandlerService.getInstance().createModelHandler(handlerID, node);
        return modelHandler instanceof IEMFModelHandler ? (IEMFModelHandler)modelHandler : null;
    }
}

