/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.predefined;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerService;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.ControllerDescriptorState;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedControllerDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PredefinedControllerState
extends ControllerDescriptorState {
    private PropertyChangeSupport changeSupport;
    private String predefinedIdState;

    public PredefinedControllerState(PredefinedControllerDescriptor propertyEditorControllerDescriptor, boolean readOnly) {
        super(propertyEditorControllerDescriptor, readOnly);
        this.predefinedIdState = propertyEditorControllerDescriptor.getPredefinedId();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public PredefinedControllerDescriptor getDescriptor() {
        return (PredefinedControllerDescriptor)super.getDescriptor();
    }

    public String getEditionDialogId() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Node generateNode(Document document) {
        Element node = document.createElement("controller");
        node.setAttribute("predefinedId", this.getPredefinedIdState());
        return node;
    }

    public void setPredefinedIdState(String predefinedIdState) {
        String oldPredefinedIdState = this.predefinedIdState;
        this.predefinedIdState = predefinedIdState;
        this.descriptor = PropertyEditorControllerService.getInstance().createPredefinedControllerDescriptor(predefinedIdState);
        this.changeSupport.firePropertyChange("predefinedId", oldPredefinedIdState, this.predefinedIdState);
        this.changeSupport.firePropertyChange("descriptor", null, this.descriptor);
    }

    public String getPredefinedIdState() {
        return this.predefinedIdState;
    }

    public void createPreview(Composite composite) {
        PropertyEditorController controller = PropertyEditorControllerService.getInstance().createPropertyEditorController(Collections.<Object>emptyList(), composite, this.descriptor);
        if (controller != null) {
            controller.createPropertyEditor(this.getDescriptor().getEditorDescriptor(), new TabbedPropertySheetWidgetFactory());
        }
    }
}

