/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.controller.predefined;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorControllerService;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IPropertyEditorControllerDescriptor;
import org.eclipse.papyrus.properties.runtime.controller.predefined.CreatePredefinedPropertyControllerProviderOperation;
import org.eclipse.papyrus.properties.runtime.controller.predefined.GetAllPredefinedPropertyEditorControllersOperation;
import org.eclipse.papyrus.properties.runtime.controller.predefined.PredefinedControllerDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedPropertyControllerProvider
extends AbstractProvider {
    public static final String PREDEFINED_ID = "predefinedId";
    protected static final String XML_PATH = "path";
    private Map<String, PredefinedControllerDescriptor> predefinedControllers = new HashMap<String, PredefinedControllerDescriptor>();
    private Bundle bundle = null;

    public boolean provides(IOperation operation) {
        if (operation instanceof CreatePredefinedPropertyControllerProviderOperation) {
            return this.predefinedControllers.containsKey(((CreatePredefinedPropertyControllerProviderOperation)operation).getPredefinedID());
        }
        return operation instanceof GetAllPredefinedPropertyEditorControllersOperation;
    }

    public void configure(IConfigurationElement providerConfiguration) {
        IConfigurationElement[] iConfigurationElementArray = providerConfiguration.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("PredefinedControllers".equals(element.getName())) {
                this.bundle = Platform.getBundle((String)providerConfiguration.getContributor().getName());
                assert (this.bundle != null) : "bundle should not be null when loading predefined controllers";
                this.readXMLConfiguration(element);
            }
            ++n2;
        }
    }

    protected void readXMLConfiguration(IConfigurationElement element) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String pluginID = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)pluginID);
            if (bundle != null) {
                URL xmlURL = bundle.getEntry(element.getAttribute(XML_PATH));
                Document document = documentBuilder.parse(new InputSource(xmlURL.toString()));
                NodeList views = document.getChildNodes();
                int i = 0;
                while (i < views.getLength()) {
                    Node predefinedControllerNode = views.item(i);
                    if ("predefinedControllers".equals(predefinedControllerNode.getNodeName())) {
                        this.parsePredefinedControllersNode(predefinedControllerNode);
                    }
                    ++i;
                }
            }
        }
        catch (ParserConfigurationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        catch (SAXException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public IPropertyEditorControllerDescriptor retrievePropertyEditorControllerDescriptor(String predefinedID) {
        return this.predefinedControllers.get(predefinedID);
    }

    public Map<String, PredefinedControllerDescriptor> getAllPredefinedProviders() {
        return this.predefinedControllers;
    }

    public File getXmlFile(IConfigurationElement element, String path) throws IOException {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        Activator.log.debug(bundle != null ? bundle.toString() : "not a bundle");
        if (bundle != null) {
            URL urlFile = bundle.getEntry(path);
            urlFile = FileLocator.resolve((URL)urlFile);
            if ("file".equals((urlFile = FileLocator.toFileURL((URL)urlFile)).getProtocol())) {
                return new File(urlFile.getFile());
            }
        }
        return null;
    }

    protected void parsePredefinedControllersNode(Node predefinedControllerNode) {
        NodeList children = predefinedControllerNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if ("predefinedController".equals(childNode.getNodeName())) {
                this.parsePredefinedController(childNode);
            }
            ++i;
        }
    }

    protected void parsePredefinedController(Node childNode) {
        if (childNode.hasAttributes()) {
            Node controllerIDNode = childNode.getAttributes().getNamedItem("id");
            Node predefinedIDNode = childNode.getAttributes().getNamedItem(PREDEFINED_ID);
            if (controllerIDNode != null && predefinedIDNode != null) {
                String controllerID = controllerIDNode.getNodeValue();
                String predefinedID = predefinedIDNode.getNodeValue();
                IPropertyEditorControllerDescriptor descriptor = PropertyEditorControllerService.getInstance().createPropertyEditorControllerDescriptor(controllerID, childNode, this.bundle);
                this.predefinedControllers.put(predefinedID, new PredefinedControllerDescriptor(predefinedID, descriptor));
            }
        } else {
            Activator.log.error("Impossible to find attributes for predefined controller node", null);
        }
    }
}

