/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.dialogs;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IBindingLabelProviderDescriptor;

public class EMFFeatureBindingLabelProviderDescriptor
implements IBindingLabelProviderDescriptor {
    private final String message;
    private String[] featuresNameToEdit;

    public EMFFeatureBindingLabelProviderDescriptor(String message, String[] featuresNameToEdit) {
        this.message = message;
        this.featuresNameToEdit = featuresNameToEdit;
    }

    public String getMessage() {
        return this.message;
    }

    public String[] getFeaturesNameToBind() {
        return this.featuresNameToEdit;
    }

    public String computeBindings(Object objectToEdit) {
        ArrayList<Object> bindings = new ArrayList<Object>();
        if (objectToEdit instanceof EObject) {
            String[] stringArray = this.getFeaturesNameToBind();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                EStructuralFeature feature = this.getFeatureByName((EObject)objectToEdit, name);
                if (feature != null) {
                    Object value = ((EObject)objectToEdit).eGet(feature);
                    bindings.add(value);
                } else {
                    Activator.log.error("impossible to find the feature with name : " + name, null);
                }
                ++n2;
            }
        }
        return NLS.bind((String)this.getMessage(), (Object[])bindings.toArray(new String[0]));
    }

    protected EStructuralFeature getFeatureByName(EObject objectToEdit, String name) {
        EStructuralFeature feature = objectToEdit.eClass().getEStructuralFeature(name);
        if (feature != null) {
            return feature;
        }
        return null;
    }
}

