/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.descriptor.IBindingLabelProviderDescriptor;
import org.eclipse.papyrus.properties.runtime.view.DialogDescriptor;
import org.eclipse.papyrus.properties.runtime.view.IFragmentDescriptor;
import org.eclipse.papyrus.properties.runtime.view.content.AbstractContainerDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDialog
extends StatusDialog {
    private final DialogDescriptor descriptor;
    private final List<Object> objectsToEdit;
    private final TabbedPropertySheetWidgetFactory widgetFactory;
    protected Button okButton;

    public PropertyDialog(Shell parent, DialogDescriptor descriptor, List<Object> objectsToEdit, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent);
        this.descriptor = descriptor;
        this.objectsToEdit = objectsToEdit;
        this.widgetFactory = widgetFactory;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(640, 480);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return this.getMessageFromDescriptor(this.descriptor.getTitle());
    }

    protected String getMessage() {
        return this.getMessageFromDescriptor(this.descriptor.getMessage());
    }

    protected String getMessageFromDescriptor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IBindingLabelProviderDescriptor) {
            if (this.objectsToEdit.size() == 1) {
                return ((IBindingLabelProviderDescriptor)object).computeBindings(this.objectsToEdit.get(0));
            }
            if (this.objectsToEdit.size() > 1) {
                return String.valueOf(((IBindingLabelProviderDescriptor)object).computeBindings(this.objectsToEdit.get(0))) + " (and others)";
            }
            return "No object to edit";
        }
        Activator.log.warn("the object from which string is computed is not a String either a label descriptor");
        return "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getWidgetFactory().setBackground(composite.getBackground());
        Label messageLabel = this.getWidgetFactory().createLabel(composite, this.getMessage(), 0);
        GridData data = new GridData(4, 4, true, false);
        messageLabel.setLayoutData((Object)data);
        Label separator = this.getWidgetFactory().createSeparator(composite, 256);
        separator.setLayoutData((Object)data);
        Color defaultColor = this.getShell().getDisplay().getSystemColor(25);
        this.getWidgetFactory().setBackground(defaultColor);
        ScrolledComposite scrolledComposite = this.getWidgetFactory().createScrolledComposite(composite, 2048);
        scrolledComposite.setAlwaysShowScrollBars(false);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        scrolledComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        scrolledComposite.setLayoutData((Object)data);
        Composite containerComposite = this.getWidgetFactory().createComposite((Composite)scrolledComposite);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        containerComposite.setLayout((Layout)layout);
        scrolledComposite.setLayout((Layout)layout);
        scrolledComposite.setContent((Control)containerComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        ArrayList<AbstractContainerDescriptor> containers = new ArrayList<AbstractContainerDescriptor>();
        for (IFragmentDescriptor fragmentDescriptor : this.getFragmentsId()) {
            if (fragmentDescriptor == null) continue;
            for (AbstractContainerDescriptor abstractContainerDescriptor : fragmentDescriptor.getContainerDescriptors()) {
                abstractContainerDescriptor.createContent(containerComposite, this.getWidgetFactory(), this.objectsToEdit);
                containers.add(abstractContainerDescriptor);
            }
        }
        return composite;
    }

    protected List<IFragmentDescriptor> getFragmentsId() {
        return this.descriptor.getFragmentDescriptors();
    }

    protected List<Object> getObjectsToEdit() {
        return this.objectsToEdit;
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }
}

