/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.controller.IBoundedValuesController;
import org.eclipse.papyrus.properties.runtime.controller.PropertyEditorController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceExplorerDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.papyrus.properties.runtime.dialogs.ReferenceExplorerDialog";
    protected String filter = null;
    private IBoundedValuesController controller;
    private ILabelProvider labelProvider;
    private Comparator<?> referenceComparator = new ReferenceComparator();

    public ReferenceExplorerDialog(Shell parentShell, IBoundedValuesController controller, boolean allowMultiple) {
        super(parentShell, allowMultiple);
        this.controller = controller;
        this.labelProvider = controller.getBrowserLabelProvider();
        this.setTitle("Select " + ((PropertyEditorController)((Object)controller)).getPropertyEditor().getDescriptor().getLabel());
        this.setMessage("Select the reference you want for " + ((PropertyEditorController)((Object)controller)).getPropertyEditor().getDescriptor().getLabel() + "\nTooltip: " + ((PropertyEditorController)((Object)controller)).getPropertyEditor().getTooltipText());
        this.setListLabelProvider(this.labelProvider);
        this.setDetailsLabelProvider(this.labelProvider);
        this.setInitialPattern("**");
        this.setInitialSelections(controller.getCurrentValues());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ObjectItemFilter();
    }

    protected Comparator<?> getItemsComparator() {
        return this.referenceComparator;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        Object[] elements = this.getElements();
        if (elements == null) {
            return;
        }
        progressMonitor.beginTask("Filling reference list", elements.length);
        int i = 0;
        while (i < elements.length && !progressMonitor.isCanceled()) {
            contentProvider.add(elements[i], itemsFilter);
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    protected Object[] getElements() {
        Object values = this.controller.getAvailableValues();
        if (values instanceof Object[]) {
            return (Object[])values;
        }
        if (values instanceof List) {
            return ((List)values).toArray();
        }
        if (values instanceof Object) {
            return Arrays.asList(values).toArray();
        }
        return new Object[]{values};
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    static /* synthetic */ ILabelProvider access$0(ReferenceExplorerDialog referenceExplorerDialog) {
        return referenceExplorerDialog.labelProvider;
    }

    private class ObjectItemFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ObjectItemFilter() {
            super((FilteredItemsSelectionDialog)ReferenceExplorerDialog.this);
        }

        public boolean matchItem(Object item) {
            String value = ReferenceExplorerDialog.this.labelProvider.getText(item);
            if (value != null) {
                return this.matches(value);
            }
            Activator.log.debug("Value should not be null for object :" + item);
            return false;
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }
    }

    private static class ReferenceComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return 1;
        }
    }
}

