/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.IPropertyModelHandlerFactory;
import org.eclipse.swt.graphics.Image;

public class ModelHandlerFactoryDescriptor {
    protected static final String DEFAULT_DESCRIPTION = "";
    protected final String name;
    protected final String id;
    protected final String description;
    protected final String iconPath;
    protected final String pluginId;
    protected IConfigurationElement element;
    protected IPropertyModelHandlerFactory factory;
    private boolean parseFailed = false;
    public static String ATTRIBUTE_NAME = "name";
    public static String ATTRIBUTE_DESCRIPTION = "description";
    public static String ATTRIBUTE_ID = "id";
    public static String ATTRIBUTE_ICON = "icon";
    public static String ATTRIBUTE_CLASS_NAME = "class";

    public ModelHandlerFactoryDescriptor(IConfigurationElement element) {
        this.name = element.getAttribute(ATTRIBUTE_NAME);
        this.id = element.getAttribute(ATTRIBUTE_ID);
        String tmpDesc = element.getAttribute(ATTRIBUTE_DESCRIPTION);
        this.description = tmpDesc != null ? tmpDesc : DEFAULT_DESCRIPTION;
        this.iconPath = element.getAttribute(ATTRIBUTE_ICON);
        this.pluginId = element.getContributor().getName();
        this.element = element;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public Image getImage() {
        return Activator.getImageFromDescriptor(Activator.imageDescriptorFromPlugin((String)this.pluginId, (String)this.iconPath));
    }

    public IPropertyModelHandlerFactory getModelHandlerFactory() {
        if (this.factory == null && !this.parseFailed) {
            try {
                this.factory = (IPropertyModelHandlerFactory)this.element.createExecutableExtension(ATTRIBUTE_CLASS_NAME);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                this.parseFailed = true;
            }
        }
        return this.factory;
    }
}

