/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.properties.runtime.modelhandler.IPropertyModelHandlerFactory;
import org.eclipse.papyrus.properties.runtime.modelhandler.ModelHandlerFactoryDescriptor;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHandlerService {
    public static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.properties.runtime.propertyModelHandler";
    protected final List<ModelHandlerFactoryDescriptor> modelHandlerFactoryDescriptors;
    protected static ModelHandlerService instance;

    protected ModelHandlerService(List<ModelHandlerFactoryDescriptor> modelHandlerFactoryDescriptors) {
        this.modelHandlerFactoryDescriptors = modelHandlerFactoryDescriptors;
    }

    public static synchronized ModelHandlerService getInstance() {
        if (instance == null) {
            instance = ModelHandlerService.createService();
        }
        return instance;
    }

    protected static ModelHandlerService createService() {
        IConfigurationElement[] configElements;
        ArrayList<ModelHandlerFactoryDescriptor> modelHandlers = new ArrayList<ModelHandlerFactoryDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ModelHandlerFactoryDescriptor descriptor = new ModelHandlerFactoryDescriptor(element);
            modelHandlers.add(descriptor);
            ++n2;
        }
        return new ModelHandlerService(modelHandlers);
    }

    public Object createModelHandler(String id, Node featureNode) {
        for (ModelHandlerFactoryDescriptor descriptor : this.modelHandlerFactoryDescriptors) {
            IPropertyModelHandlerFactory factory;
            if (!id.equals(descriptor.getId()) || (factory = descriptor.getModelHandlerFactory()) == null) continue;
            return factory.createModelHandler(featureNode);
        }
        return null;
    }
}

