/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.properties.runtime.modelhandler.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.properties.runtime.Activator;
import org.eclipse.papyrus.properties.runtime.modelhandler.emf.EnumerationEMFModelHandler;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IBoundedValuesPropertyEditorDescriptor;
import org.eclipse.papyrus.properties.runtime.propertyeditor.descriptor.IPropertyEditorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanEMFModelHandler
extends EnumerationEMFModelHandler {
    public static final String ID = "Boolean";

    public BooleanEMFModelHandler(String featureName) {
        super(featureName);
    }

    @Override
    public Object getValueToEdit(EObject objectToEdit) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        Object value = objectToEdit.eGet(featureToEdit);
        return value instanceof Boolean ? ((Boolean)value).toString() : value;
    }

    @Override
    public void setValueInModel(EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return;
        }
        if (newValue == null || newValue.equals("")) {
            objectToEdit.eUnset(featureToEdit);
        } else if (newValue instanceof String) {
            objectToEdit.eSet(featureToEdit, (Object)Boolean.parseBoolean((String)newValue));
        } else if (newValue instanceof Boolean) {
            objectToEdit.eSet(featureToEdit, newValue);
        } else if (newValue instanceof List) {
            ArrayList<Boolean> newValues = new ArrayList<Boolean>();
            for (Object value : (List)newValue) {
                if (value instanceof String) {
                    newValues.add(Boolean.parseBoolean((String)value));
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                newValues.add((Boolean)value);
            }
            objectToEdit.eSet(featureToEdit, newValues);
        }
    }

    @Override
    public void completeEditorDescriptor(IPropertyEditorDescriptor descriptor, List<? extends EObject> objectToEdit) {
        if (objectToEdit.size() < 1) {
            return;
        }
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit.get(0));
        if (featureToEdit == null) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        if (featureToEdit.getLowerBound() == 0) {
            values.add("");
        }
        values.add("true");
        values.add("false");
        if (descriptor instanceof IBoundedValuesPropertyEditorDescriptor) {
            ((IBoundedValuesPropertyEditorDescriptor)((Object)descriptor)).setAvailableValues(values);
        } else {
            Activator.log.debug("Warning: " + descriptor + "could not be completed.");
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public SetRequest[] getSetRequest(TransactionalEditingDomain domain, EObject objectToEdit, Object newValue) {
        EStructuralFeature featureToEdit = this.getFeatureByName(objectToEdit);
        if (featureToEdit == null) {
            return null;
        }
        if (newValue == null || newValue.equals("")) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, featureToEdit.getDefaultValue())};
        }
        if (newValue instanceof String) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, (Object)Boolean.parseBoolean((String)newValue))};
        }
        if (newValue instanceof Boolean) {
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, newValue)};
        }
        if (newValue instanceof List) {
            ArrayList<Boolean> newValues = new ArrayList<Boolean>();
            for (Object value : (List)newValue) {
                if (value instanceof String) {
                    newValues.add(Boolean.parseBoolean((String)value));
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                newValues.add((Boolean)value);
            }
            return new SetRequest[]{new SetRequest(domain, objectToEdit, featureToEdit, newValues)};
        }
        return null;
    }
}

